/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Symbol {
    public final String str;
    final DataBuffer nameBuffer;
    final int nameStart;
    final int nameEnd;
    private final String prefix;
    private final String localName;
    int hitCount;
    int noHitsFoundCount;

    Symbol(String string, DataBuffer dataBuffer, int n, int n2) {
        this.str = string;
        this.nameBuffer = dataBuffer;
        this.nameStart = n;
        this.nameEnd = n2;
        int n3 = this.checkQName(string);
        if (n3 == -1) {
            this.prefix = null;
            this.localName = null;
        } else if (n3 == 0) {
            this.prefix = "";
            this.localName = this.str;
        } else {
            this.prefix = this.str.substring(0, n3).intern();
            this.localName = this.str.substring(n3 + 1).intern();
        }
    }

    Symbol(Symbol symbol, DataBuffer dataBuffer, int n, int n2) {
        this.str = symbol.str;
        this.nameBuffer = dataBuffer;
        this.nameStart = n;
        this.nameEnd = n2;
        this.prefix = symbol.prefix;
        this.localName = symbol.localName;
    }

    public String toString() {
        return this.str;
    }

    boolean equalsString(String string) {
        return this.str.equals(string);
    }

    void setValues(XMLString xMLString) {
        xMLString.setValues(this.nameBuffer, this.nameStart, this.nameEnd);
    }

    boolean setValuesIfKnownQName(QName qName) {
        if (this.prefix != null) {
            this.setQNameValues(qName);
            return true;
        }
        return false;
    }

    public void setQNameValues(QName qName) {
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    public boolean skippedMatchingQName(ParsedEntity parsedEntity, QName qName) {
        return parsedEntity.skippedBytesInRangeForXMLString(this.nameBuffer.bytes, this.nameStart, this.nameEnd, qName);
    }

    private int checkQName(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        block0: while (true) {
            char c;
            int n4;
            if (n2 == n) {
                return -1;
            }
            if ((n4 = string.charAt(n2++)) >= 55296 && n4 < 57344) {
                if (n2 == n) {
                    return -1;
                }
                if ((c = string.charAt(n2++)) >= '\udc00' && c < '\ue000') {
                    n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                } else {
                    return -1;
                }
            }
            if (!bl || !XMLCharacterProperties.nameStartChar10(n4)) {
                if (XMLCharacterProperties.nameStartChar11(n4)) {
                    bl = false;
                } else {
                    return -1;
                }
            }
            while (true) {
                if (n2 == n) {
                    return n3;
                }
                if ((n4 = string.charAt(n2++)) == 58) {
                    if (n3 == 0) {
                        n3 = n2 - 1;
                        continue block0;
                    }
                    return -1;
                }
                if (n4 >= 55296 && n4 < 57344) {
                    if (n2 == n) {
                        return -1;
                    }
                    if ((c = string.charAt(n2++)) >= '\udc00' && c < '\ue000') {
                        n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                    } else {
                        return -1;
                    }
                }
                if (bl && XMLCharacterProperties.nameChar10(n4)) continue;
                if (!XMLCharacterProperties.nameChar11(n4)) break block0;
                bl = false;
            }
            break;
        }
        return -1;
    }
}

