/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class XMLEventReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private Map<Integer, List<Namespace>> namespaces = new HashMap<Integer, List<Namespace>>();
    private XMLEventReaderAttributes indexedAttributeList = new XMLEventReaderAttributes();
    private XMLEvent lastEvent;

    public XMLEventReaderReader() {
    }

    public XMLEventReaderReader(Unmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (input instanceof XMLEventReaderInputSource) {
            XMLEventReader xmlEventReader = ((XMLEventReaderInputSource)input).getXmlEventReader();
            this.parse(xmlEventReader);
        }
    }

    @Override
    public Locator getLocator() {
        if (this.locator == null) {
            this.locator = new EventReaderLocator();
        }
        ((EventReaderLocator)this.locator).setEvent(this.lastEvent);
        return this.locator;
    }

    private void parse(XMLEventReader xmlEventReader) throws SAXException {
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlEventReader.nextEvent());
            while (this.depth > 0) {
                this.parseEvent(xmlEventReader.nextEvent());
            }
            this.contentHandler.endDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void parseEvent(XMLEvent xmlEvent) throws SAXException {
        switch (xmlEvent.getEventType()) {
            case 10: {
                break;
            }
            case 12: {
                Characters characters = xmlEvent.asCharacters();
                if (this.lexicalHandler == null) {
                    this.contentHandler.characters(characters.getData().toCharArray(), 0, characters.getData().length());
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.contentHandler.characters(characters.getData().toCharArray(), 0, characters.getData().length());
                this.lexicalHandler.endCDATA();
                break;
            }
            case 4: {
                char[] characters = xmlEvent.asCharacters().getData().toCharArray();
                this.contentHandler.characters(characters, 0, characters.length);
                break;
            }
            case 5: {
                if (this.lexicalHandler == null) break;
                char[] comment = ((Comment)xmlEvent).getText().toCharArray();
                this.lexicalHandler.comment(comment, 0, comment.length);
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 2: {
                List<Namespace> declaredNs = this.namespaces.get(this.depth);
                --this.depth;
                EndElement endElement = xmlEvent.asEndElement();
                QName name = endElement.getName();
                String prefix = endElement.getName().getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    this.contentHandler.endElement(name.getNamespaceURI(), name.getLocalPart(), name.getLocalPart());
                } else {
                    this.contentHandler.endElement(name.getNamespaceURI(), name.getLocalPart(), String.valueOf(prefix) + ':' + name.getLocalPart());
                }
                if (declaredNs == null) break;
                for (Namespace next : declaredNs) {
                    this.contentHandler.endPrefixMapping(next.getPrefix());
                }
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)xmlEvent;
                this.contentHandler.processingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 6: {
                char[] characters = xmlEvent.asCharacters().getData().toCharArray();
                this.contentHandler.characters(characters, 0, characters.length);
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 1: {
                this.lastEvent = xmlEvent;
                ++this.depth;
                StartElement startElement = xmlEvent.asStartElement();
                Iterator<Namespace> namespaces = startElement.getNamespaces();
                ArrayList<Namespace> declaredNs = null;
                if (namespaces.hasNext()) {
                    declaredNs = new ArrayList<Namespace>();
                }
                while (namespaces.hasNext()) {
                    Namespace next = namespaces.next();
                    this.contentHandler.startPrefixMapping(next.getPrefix(), next.getNamespaceURI());
                    declaredNs.add(next);
                }
                if (declaredNs != null) {
                    this.namespaces.put(this.depth, declaredNs);
                }
                QName qName = startElement.getName();
                String prefix = qName.getPrefix();
                this.indexedAttributeList.setIterators(startElement.getAttributes(), startElement.getNamespaces());
                if (prefix == null || prefix.length() == 0) {
                    this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), this.indexedAttributeList);
                    break;
                }
                this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), String.valueOf(prefix) + ':' + qName.getLocalPart(), this.indexedAttributeList);
            }
        }
    }

    private static final class EventReaderLocator
    implements Locator2 {
        private XMLEvent event;

        public void setEvent(XMLEvent e) {
            this.event = e;
        }

        @Override
        public String getPublicId() {
            if (this.event == null) {
                return null;
            }
            return this.event.getLocation().getPublicId();
        }

        @Override
        public String getSystemId() {
            if (this.event == null) {
                return null;
            }
            return this.event.getLocation().getSystemId();
        }

        @Override
        public int getLineNumber() {
            if (this.event == null) {
                return -1;
            }
            return this.event.getLocation().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            if (this.event == null) {
                return -1;
            }
            return this.event.getLocation().getColumnNumber();
        }

        @Override
        public String getXMLVersion() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }
    }

    private static final class XMLEventReaderAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private Iterator namespaces;
        private Iterator attrs;

        private XMLEventReaderAttributes() {
        }

        public void setIterators(Iterator attrs, Iterator namespaces) {
            this.reset();
            this.namespaces = namespaces;
            this.attrs = attrs;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                if (this.attrs.hasNext() || this.namespaces.hasNext()) {
                    String localName;
                    String uri;
                    Attribute next;
                    ArrayList<XMLReaderAdapter.Attribute> attributesList = new ArrayList<XMLReaderAdapter.Attribute>();
                    while (this.namespaces.hasNext()) {
                        String qName;
                        next = (Namespace)this.namespaces.next();
                        uri = "http://www.w3.org/2000/xmlns/";
                        localName = next.getPrefix();
                        if (localName == null || localName.length() == 0) {
                            localName = "xmlns";
                            qName = "xmlns";
                        } else {
                            qName = "xmlns:" + localName;
                        }
                        String value = next.getNamespaceURI();
                        attributesList.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value));
                    }
                    while (this.attrs.hasNext()) {
                        next = (Attribute)this.attrs.next();
                        uri = next.getName().getNamespaceURI();
                        localName = next.getName().getLocalPart();
                        String prefix = next.getName().getPrefix();
                        String qName = prefix == null || prefix.length() == 0 ? localName : String.valueOf(prefix) + ':' + localName;
                        String value = next.getValue();
                        attributesList.add(new XMLReaderAdapter.Attribute(uri, localName, qName, value));
                    }
                    this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                } else {
                    this.attributes = NO_ATTRIBUTES;
                }
            }
            return this.attributes;
        }
    }
}

