/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.Symbol;
import com.ibm.xml.xlxp2.scan.util.SymbolMap;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SymbolTable {
    private static final boolean TRACE_PUBLIC_METHODS = false;

    public SymbolTable() {
    }

    public SymbolTable(SymbolMapHolder symbolMapHolder) {
        this();
    }

    public void updateSymbolMapHolder() {
    }

    public void reset(boolean bl) {
        SymbolMap.resetMap(bl);
    }

    public String addSymbol(XMLString xMLString) {
        Symbol symbol = SymbolMap.addSymbol(xMLString);
        return symbol.str;
    }

    public String addSymbol(String string) {
        Symbol symbol = SymbolMap.addSymbol(string);
        return symbol.str;
    }

    public String addSymbolSetValues(XMLString xMLString, XMLString xMLString2) {
        Symbol symbol = SymbolMap.addSymbol(xMLString);
        symbol.setValues(xMLString2);
        return symbol.str;
    }

    public String addSymbolSetValues(String string, XMLString xMLString) {
        String string2;
        Symbol symbol = SymbolMap.addSymbol(string);
        if (symbol != null) {
            symbol.setValues(xMLString);
            string2 = symbol.str;
        } else {
            xMLString.clear();
            string2 = null;
        }
        return string2;
    }

    private static String symbolString(Symbol symbol) {
        return symbol != null ? "\"" + symbol.str + "\"" : "null";
    }

    public Symbol addNameSymbol(QName qName) {
        Symbol symbol = SymbolMap.addSymbol(qName);
        qName.rawName = qName.localName = symbol.str;
        qName.nsURI = "";
        qName.prefix = "";
        return symbol;
    }

    public Symbol getQNameSymbol(QName qName, int n) {
        Symbol symbol = SymbolMap.getQNameSymbol(qName, n);
        return symbol;
    }

    public Symbol getQNameSymbol(QName qName) {
        Symbol symbol = SymbolMap.getQNameSymbol(qName);
        return symbol;
    }
}

