/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class EntityDeclPool {
    private static final boolean DEBUG_ADDITIONS = false;
    public static final int EntityType_Predefined = 0;
    public static final int EntityType_InternalGeneral = 1;
    public static final int EntityType_ExternalGeneral = 2;
    public static final int EntityType_InternalParameter = 3;
    public static final int EntityType_ExternalParameter = 4;
    public static final int EntityType_Unparsed = 5;
    private SymbolTable fSymbolTable;
    private XMLStringBuffer fStringBuffer;
    private HashMap<String, EntityDecl> fEntityDecls;
    private HashMap<String, EntityDecl> fPEDecls;

    public EntityDeclPool(SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer) {
        this.fSymbolTable = symbolTable;
        this.fStringBuffer = xMLStringBuffer;
        this.fEntityDecls = new HashMap();
        this.createPredefinedEntities();
    }

    private void clearMap(HashMap<String, EntityDecl> hashMap) {
        Collection<EntityDecl> collection = hashMap.values();
        for (EntityDecl entityDecl : collection) {
            if (entityDecl.content == null) continue;
            entityDecl.content.unregister();
        }
        hashMap.clear();
    }

    public void reset(boolean bl) {
        this.clearMap(this.fEntityDecls);
        if (this.fPEDecls != null) {
            this.clearMap(this.fPEDecls);
        }
        this.createPredefinedEntities();
    }

    public EntityDecl lookupEntity(String string) {
        return this.fEntityDecls.get(string);
    }

    public EntityDecl lookupPE(String string) {
        return this.fPEDecls == null ? null : this.fPEDecls.get(string);
    }

    public boolean addInternalEntityDecl(XMLString xMLString, XMLString xMLString2, boolean bl) {
        String string = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(string) != null) {
            return false;
        }
        EntityDecl entityDecl = new EntityDecl(string, this.saveXMLString(xMLString2, true), bl, true);
        this.fEntityDecls.put(string, entityDecl);
        return true;
    }

    public boolean addExternalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, String string, boolean bl) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(string2) != null) {
            return false;
        }
        EntityDecl entityDecl = new EntityDecl(string2, this.saveXMLString(xMLString2, false), this.saveXMLString(xMLString3, false), string, bl, true);
        this.fEntityDecls.put(string2, entityDecl);
        return true;
    }

    public boolean addUnparsedEntityDecl(XMLString xMLString, boolean bl) {
        String string = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(string) != null) {
            return false;
        }
        EntityDecl entityDecl = new EntityDecl(string, bl);
        this.fEntityDecls.put(string, entityDecl);
        return true;
    }

    public boolean addInternalPEDecl(XMLString xMLString, XMLString xMLString2, boolean bl) {
        String string = this.fSymbolTable.addSymbol(xMLString);
        if (this.fPEDecls != null && this.fPEDecls.get(string) != null) {
            return false;
        }
        EntityDecl entityDecl = new EntityDecl(string, this.saveXMLString(xMLString2, true), bl, false);
        if (this.fPEDecls == null) {
            this.fPEDecls = new HashMap();
        }
        this.fPEDecls.put(string, entityDecl);
        return true;
    }

    public boolean addExternalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, String string, boolean bl) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.fPEDecls != null && this.fPEDecls.get(string2) != null) {
            return false;
        }
        EntityDecl entityDecl = new EntityDecl(string2, this.saveXMLString(xMLString2, false), this.saveXMLString(xMLString3, false), string, bl, false);
        if (this.fPEDecls == null) {
            this.fPEDecls = new HashMap();
        }
        this.fPEDecls.put(string2, entityDecl);
        return true;
    }

    private void createPredefinedEntities() {
        this.addPredefinedEntity("lt", 60);
        this.addPredefinedEntity("gt", 62);
        this.addPredefinedEntity("amp", 38);
        this.addPredefinedEntity("apos", 39);
        this.addPredefinedEntity("quot", 34);
    }

    private void addPredefinedEntity(String string, int n) {
        EntityDecl entityDecl = new EntityDecl(string, n);
        this.fEntityDecls.put(string, entityDecl);
    }

    private XMLString saveXMLString(XMLString xMLString, boolean bl) {
        if (xMLString != null) {
            XMLString xMLString2 = new XMLString();
            if (this.fStringBuffer != null && this.fStringBuffer.contains(xMLString)) {
                xMLString2.setValues(xMLString);
            } else {
                if (this.fStringBuffer == null) {
                    this.fStringBuffer = new XMLStringBuffer();
                }
                this.fStringBuffer.addXMLString(xMLString, xMLString2);
                if (bl) {
                    this.fStringBuffer.appendChar(0);
                }
            }
            return xMLString2;
        }
        return null;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class EntityDecl {
        public final int type;
        public final boolean declaredExternally;
        public final String name;
        public int charValue;
        public XMLString content;
        public XMLString publicID;
        public XMLString systemID;
        public String baseURI;

        public EntityDecl(String string, XMLString xMLString, boolean bl, boolean bl2) {
            this.type = bl2 ? 1 : 3;
            this.declaredExternally = bl;
            this.name = string;
            this.content = xMLString;
        }

        public EntityDecl(String string, XMLString xMLString, XMLString xMLString2, String string2, boolean bl, boolean bl2) {
            this.type = bl2 ? 2 : 4;
            this.declaredExternally = bl;
            this.name = string;
            this.publicID = xMLString;
            this.systemID = xMLString2;
            this.baseURI = string2;
        }

        public EntityDecl(String string, boolean bl) {
            this.type = 5;
            this.declaredExternally = bl;
            this.name = string;
        }

        public EntityDecl(String string, int n) {
            this.type = 0;
            this.declaredExternally = false;
            this.name = string;
            this.charValue = n;
        }
    }
}

