/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.hpel;

import com.ibm.ejs.ras.hpel.StackFinder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class TraceNLSResolver {
    public static final String DEBUG_TRACE_NLS_PROPERTY = "com.ibm.ejs.ras.debugTraceNLSResolver";
    private static Boolean debugTraceNLSResolver = null;
    protected static boolean makeNoise = false;
    protected static final String nullKey = "null";
    protected static final String svNullBundleName = "Resource Bundle name is null, key = {0}";
    protected static final String svBundleNotLoaded = "Unable to load ResourceBundle {0}";
    protected static final String svNullKeyMessage = "Null key passed while using ResourceBundle {0}";
    protected static final String svMalformedMessage = "No message text associated with key {0} in bundle {1}";
    private static TraceNLSResolver instance = new TraceNLSResolver();
    private static StackFinder finder = null;

    public static final TraceNLSResolver getInstance() {
        if (debugTraceNLSResolver == null) {
            debugTraceNLSResolver = Boolean.getBoolean(DEBUG_TRACE_NLS_PROPERTY);
            makeNoise = debugTraceNLSResolver;
        }
        return instance;
    }

    public String getMessage(Class<?> aClass, ResourceBundle bundle, String bundleName, String key, Object[] args, String defaultString, boolean format, Locale locale, boolean quiet) {
        String returnValue = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            if (bundle == null) {
                bundle = this.getResourceBundle(aClass, bundleName, locale);
            }
            if ((returnValue = bundle.getString(key)).equals("")) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svMalformedMessage, new Object[]{key, bundleName});
                }
                returnValue = defaultString == null ? key : defaultString;
            }
            if (!format) {
                return returnValue;
            }
            return this.getFormattedMessage(returnValue, args);
        }
        catch (RuntimeException re) {
            if (bundleName == null) {
                if (key == null && defaultString == null) {
                    if (!quiet) {
                        TraceNLSResolver.logEvent(svNullBundleName, new Object[]{nullKey});
                    }
                    return MessageFormat.format(svNullBundleName, nullKey);
                }
                if (defaultString == null) {
                    if (!quiet) {
                        TraceNLSResolver.logEvent(svNullBundleName, new Object[]{defaultString});
                    }
                    returnValue = key;
                } else {
                    if (!quiet) {
                        TraceNLSResolver.logEvent(svNullBundleName, new Object[]{key});
                    }
                    returnValue = defaultString;
                }
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (bundle == null) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svBundleNotLoaded, new Object[]{bundleName});
                }
                if (key == null && defaultString == null) {
                    return MessageFormat.format(svBundleNotLoaded, bundleName);
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (key == null) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svNullKeyMessage, new Object[]{bundleName});
                }
                if (defaultString == null) {
                    return MessageFormat.format(svNullKeyMessage, bundleName);
                }
                returnValue = defaultString;
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (!quiet) {
                TraceNLSResolver.logEvent(svMalformedMessage, new Object[]{key, bundleName});
            }
            returnValue = defaultString == null ? key : defaultString;
            if (!format) {
                return returnValue;
            }
            return this.getFormattedMessage(returnValue, args);
        }
    }

    public String getFormattedMessage(String message, Object[] args) {
        if (args == null || message == null) {
            return message;
        }
        String formattedMessage = null;
        try {
            formattedMessage = MessageFormat.format(message, args);
        }
        catch (IllegalArgumentException e) {
            return message;
        }
        return formattedMessage;
    }

    public ResourceBundle getResourceBundle(Class<?> aClass, String bundleName, Locale locale) {
        ResourceBundle bundle = null;
        ClassLoader classLoader = null;
        if (bundleName == null) {
            throw new NullPointerException("Unable to load resource bundle: null bundleName");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (aClass == null) {
            if (finder == null) {
                finder = StackFinder.getInstance();
            }
            if (finder != null) {
                aClass = finder.getCaller();
            }
        }
        if (aClass != null) {
            try {
                classLoader = aClass.getClassLoader();
                bundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
            }
            catch (RuntimeException re) {
                TraceNLSResolver.logEvent("Unable to load {0} from {1} (from class {2}) in {3}; caught exception: {4}", new Object[]{bundleName, classLoader, aClass, locale, re});
            }
        }
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (RuntimeException re) {
                TraceNLSResolver.logEvent("Unable to load {0} from {1} in {2}; caught exception: {3}", new Object[]{bundleName, classLoader, locale, re});
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    bundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
                }
                catch (PrivilegedActionException pae) {
                    TraceNLSResolver.logEvent("Unable to load {0} from {1} in {2}; caught exception: {3}", new Object[]{bundleName, classLoader, locale, pae});
                    throw new RuntimeException("Unable to get context classloader", pae);
                }
            }
        }
        return bundle;
    }

    protected static final void logEvent(String message, Object[] args) {
        System.err.println("com.ibm.ejs.ras.hpel.TraceNLSResolver: " + MessageFormat.format(message, args));
        Thread.dumpStack();
    }
}

