/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.IMaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class SetMaintenanceTask
extends BaseCommandTask {
    private static final String className = SetMaintenanceTask.class.getName();
    private static final String ARG_BREAK = "--break";
    private static final String ARG_FORCE = "--force";
    private static final String ARG_SERVER = "--server";
    private static final String ARG_USR_DIR = "--usrDir";
    private static final String ARG_HOSTNAME = "--hostName";
    private final IMaintenanceModeMBeanConnection maintenanceMode;

    public SetMaintenanceTask(String scriptName, IMaintenanceModeMBeanConnection mbeanconn) {
        super(scriptName, null);
        this.maintenanceMode = mbeanconn;
        this.reqArgs.add(ARG_HOSTNAME);
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add(ARG_BREAK);
        this.flagArgs.add(ARG_FORCE);
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.add(ARG_USR_DIR);
        this.knownArgs.add(ARG_SERVER);
        this.addAutoAcceptAndDisableHostnameVerificationArguments();
    }

    @Override
    public String getTaskName() {
        return "enterMaintenanceMode";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("enterMaintenanceMode.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("enterMaintenance.option-key.", "enterMaintenance.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + this.buildScriptOptions("certProps.option-key.disableHostnameVerification", "certProps.option-desc.disableHostnameVerification");
        return this.getTaskHelp("enterMaintenanceMode.desc", "enterMaintenanceMode.usage.options", "connection.option-key", "connection.option-desc", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("enterMaintenanceMode.desc", new Object[0]);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        String MAGICAL_SENTINEL = "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        Trlog.debug(className, methodName, "Validating command arguments...");
        this.validateArgumentList(args, false, false);
        Trlog.debug(className, methodName, "Parsing command arguments...");
        String controllerHost = this.getControllerHost(args);
        int port = Integer.parseInt(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String pwd = this.getControllerPassword(args);
        String hostName = this.getArgumentValue(ARG_HOSTNAME, args, null);
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String usrDir = this.getArgumentValue(ARG_USR_DIR, args, null);
        boolean force = this.getArgumentValue(ARG_FORCE, args, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        boolean breakAffinity = this.getArgumentValue(ARG_BREAK, args, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        this.handleAutoAcceptAndDisableHostnameVerificationArgs(args);
        if (serverName != null && usrDir == null || usrDir != null && serverName == null) {
            String missingArg = usrDir == null ? ARG_USR_DIR : ARG_SERVER;
            this.abort(this.getMessage("missingArg", missingArg), methodName);
        }
        this.setMaintenanceMode(controllerHost, port, user, pwd, hostName, usrDir, serverName, force, !breakAffinity);
    }

    private void setMaintenanceMode(String host, int port, String user, String pwd, String hostName, String usrDir, String serverName, boolean force, boolean affinity) throws TaskErrorException {
        String target;
        String methodName = "setMaintenanceMode";
        Trlog.enter(className, methodName, new Object[]{host, port, user, pwd.replaceAll(".", "*"), hostName, usrDir, serverName, force, affinity});
        if (serverName == null) {
            target = hostName;
        } else {
            usrDir = RepositoryPathUtility.normalizePath((String)usrDir);
            target = RepositoryPathUtility.buildServerTuple((String)hostName, (String)usrDir, (String)serverName);
        }
        try {
            Trlog.debug(className, methodName, "Setting maintenance mode on target: " + target);
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(target);
            List<Map<String, String>> results = serverName == null ? this.maintenanceMode.enterHostMaintenanceMode(host, port, user, pwd, targets, affinity, force) : this.maintenanceMode.enterServerMaintenanceMode(host, port, user, pwd, targets, affinity, force);
            Map<String, String> result = results.get(0);
            if (serverName == null) {
                this.processResult(hostName, result.get(hostName));
            }
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String key = entry.getKey();
                if (key.equals(hostName)) continue;
                int lastTupleComponent = Math.max(0, key.lastIndexOf(44));
                String name = key.substring(lastTupleComponent + 1);
                this.processResult(name, entry.getValue());
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", host), methodName);
        }
        catch (RuntimeMBeanException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        catch (ConnectException e) {
            if (e.getMessage() != null && e.getMessage().contains(this.maintenanceMode.getMaintModeConnectExceptionMsg())) {
                this.abort(this.getMessage("setMaintenanceMode.connectionError", hostName), methodName);
            } else {
                this.abort(this.getMessage("common.portError", String.valueOf(port)), methodName);
            }
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        catch (KeyManagementException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target), methodName);
        }
        catch (InstanceNotFoundException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target), methodName);
        }
        catch (NoSuchAlgorithmException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target), methodName);
        }
        catch (ReflectionException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target), methodName);
        }
        catch (MBeanException e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("setMaintenanceMode.error", target), methodName);
        }
    }

    private void processResult(String name, String status) throws TaskErrorException {
        String methodName = "processResult";
        if (status.equals("inMaintenanceMode")) {
            Trlog.debug(className, methodName, "Successfully set maintenance mode for " + name);
            this.stdout.println(this.getMessage("setMaintenanceMode.success", name));
        } else if (status.equals("alternateServerStarting")) {
            Trlog.debug(className, methodName, "Alternate server is starting for " + name);
            this.stdout.println(this.getMessage("setMaintenanceMode.alt", name));
        } else if (status.equals("alternateServerUnavailable")) {
            Trlog.debug(className, methodName, "Alternate server is not available for " + name);
            this.stderr.println(this.getMessage("setMaintenanceMode.noAltServer", name));
        } else {
            Trlog.debug(className, methodName, "Encountered an error while setting maintenance mode for " + name + ".  An unexpected server status of " + status + " has been reported.");
            this.abort(this.getMessage("setMaintenanceMode.error", name), methodName);
        }
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File cleanupRoot) throws TaskErrorException {
        throw new TaskErrorException(message);
    }
}

