/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    static final long serialVersionUID = 2892189156631596254L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AlgIdDSA";

    @Override
    public BigInteger getP() {
        if (debug != null) {
            debug.entry(16384L, className, "getP");
            debug.exit(16384L, (Object)className, "getP", this.p);
        }
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        if (debug != null) {
            debug.entry(16384L, className, "getQ");
            debug.exit(16384L, (Object)className, "getQ", this.q);
        }
        return this.q;
    }

    @Override
    public BigInteger getG() {
        if (debug != null) {
            debug.entry(16384L, className, "getG");
            debug.exit(16384L, (Object)className, "getG", this.g);
        }
        return this.g;
    }

    AlgIdDSA(DerValue val) throws IOException {
        super(val.getOID());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgIdDSA", val);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(byte[] encodedAlg) throws IOException {
        super(new DerValue(encodedAlg).getOID());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgIdDSA", (Object)encodedAlg);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(byte[] p2, byte[] q2, byte[] g2) throws IOException {
        this(new BigInteger(1, p2), new BigInteger(1, q2), new BigInteger(1, g2));
        if (debug != null) {
            Object[] parms = new Object[]{p2, q2, g2};
            debug.entry(16384L, (Object)className, "AlgIdDSA", parms);
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    public AlgIdDSA(BigInteger p2, BigInteger q2, BigInteger g2) {
        super(DSA_oid);
        if (debug != null) {
            Object[] parms = new Object[]{p2, q2, g2};
            debug.entry(16384L, (Object)className, "AlgIdDSA", parms);
        }
        try {
            this.p = p2;
            this.q = q2;
            this.g = g2;
            this.initializeParams();
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "AlgIdDSA", e2);
            }
            throw new ProviderException("Construct DSS/DSA Algorithm ID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "AlgIdDSA");
        }
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "DSA");
        }
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream out = new DerOutputStream();
        if (debug != null) {
            debug.entry(8192L, className, "initializeParams");
        }
        out.putInteger(this.p);
        out.putInteger(this.q);
        out.putInteger(this.g);
        this.params = new DerValue(48, out.toByteArray());
        if (debug != null) {
            debug.exit(8192L, className, "initializeParams");
        }
    }

    @Override
    protected void decodeParams() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "decodeParams");
        }
        if (this.params == null || this.params.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams", "DSA alg parsing error");
            }
            throw new IOException("DSA alg parsing error");
        }
        this.params.getData().reset();
        this.p = this.params.getData().getInteger();
        this.q = this.params.getData().getInteger();
        this.g = this.params.getData().getInteger();
        if (this.params.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decodeParams", "AlgIdDSA params, data overrun=" + this.params.getData().available());
            }
            throw new IOException("AlgIdDSA params, data overrun=" + this.params.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decodeParams");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.paramsToString());
        }
        return this.paramsToString();
    }

    @Override
    protected String paramsToString() {
        if (debug != null) {
            debug.entry(16384L, className, "paramsToString");
            debug.exit(16384L, (Object)className, "paramsToString", "\n    p:\n" + this.p.toString() + "\n    q:\n" + this.q.toString() + "\n    g:\n" + this.g.toString() + "\n");
        }
        return "\n    p:\n" + this.p.toString() + "\n    q:\n" + this.q.toString() + "\n    g:\n" + this.g.toString() + "\n";
    }
}

