/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class KeyPairParamRepInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.key_pair_param_rep_oid;
    private AlgorithmId value;
    private byte[] encodedValue;

    public KeyPairParamRepInfoValue(AlgorithmId algorithmId) throws IOException {
        if (algorithmId == null) {
            throw new IllegalArgumentException("KeyPairParamRepInfoValue error, algid not specified");
        }
        this.value = algorithmId;
        this.setEncodedValue();
    }

    public KeyPairParamRepInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new KeyPairParamRepInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.value = new AlgorithmId(derValue);
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(KeyPairParamRepInfoValue keyPairParamRepInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (keyPairParamRepInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            keyPairParamRepInfoValue.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof KeyPairParamRepInfoValue) {
            return this.equals((KeyPairParamRepInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "KeyPairParamRep";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        AlgorithmId algorithmId = null;
        try {
            algorithmId = new AlgorithmId(this.value.getOID(), this.value.getParameters());
        }
        catch (IOException iOException) {
            return null;
        }
        return algorithmId;
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode(derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "KeyPairParamRepInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\nalgorithm identifier: " + this.value;
        return string;
    }
}

