/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class ECNamedCurve
extends ECGenParameterSpec
implements AlgorithmParameterSpec {
    private final String a;
    private final ObjectIdentifier b;
    private final byte[] c;
    private final ECParameterSpec d;
    private static final Map<String, String> e;
    private static final Map<String, ECParameterSpec> f;
    private static final Map<String, ECParameterSpec> g;
    private static final Map<Integer, ECParameterSpec> h;
    private static Pattern i;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 5;
    private static final int m = 6;
    private static String[] z;

    public ECNamedCurve(String string) {
        super(string);
        this.a = string;
        this.d = ECNamedCurve.getECParameterSpec(this.a);
        this.b = ECNamedCurve.getOIDFromName(this.a);
        if (this.b == null) {
            throw new InvalidParameterException(z[6]);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOID(this.b);
        }
        catch (IOException iOException) {
            throw new InvalidParameterException(z[5]);
        }
        this.c = derOutputStream.toByteArray();
    }

    protected ECNamedCurve(String string, ObjectIdentifier objectIdentifier, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n2) throws IOException {
        super(string);
        this.a = string;
        this.b = objectIdentifier;
        this.d = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        this.c = derOutputStream.toByteArray();
    }

    byte[] a() {
        return (byte[])this.c.clone();
    }

    public String getName() {
        return this.a;
    }

    public ECParameterSpec getECParameterSpec() {
        return this.d;
    }

    public static ObjectIdentifier getOIDFromName(String string) {
        try {
            if (string.startsWith(z[8]) || string.startsWith(z[9])) {
                if (f.get(string) == null) {
                    throw new IOException();
                }
                return new ObjectIdentifier(string);
            }
            String string2 = e.get(string);
            if (string2 == null) {
                throw new IOException();
            }
            return new ObjectIdentifier(string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(String string) {
        ECParameterSpec eCParameterSpec = f.get(string);
        return eCParameterSpec != null ? eCParameterSpec : g.get(string);
    }

    static ECParameterSpec a(ObjectIdentifier objectIdentifier) {
        return ECNamedCurve.getECParameterSpec(objectIdentifier.toString());
    }

    public String toString() {
        return this.a + z[7] + this.b + ")";
    }

    private static BigInteger a(String string) {
        return new BigInteger(string, 16);
    }

    private static void a(String string, String string2, int n2, String string3, String string4, String string5, String string6, String string7, String string8, int n3) {
        BigInteger bigInteger = ECNamedCurve.a(string3);
        if (n2 != 1 && n2 != 5) {
            if (n2 == 2 || n2 == 6) {
                throw new RuntimeException(z[0]);
            }
            throw new RuntimeException(z[4] + n2);
        }
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECNamedCurve.a(string4), ECNamedCurve.a(string5));
        ECPoint eCPoint = new ECPoint(ECNamedCurve.a(string6), ECNamedCurve.a(string7));
        try {
            String[] stringArray;
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
            ECNamedCurve eCNamedCurve = new ECNamedCurve(string, objectIdentifier, ellipticCurve, eCPoint, ECNamedCurve.a(string8), n3);
            ECParameterSpec eCParameterSpec = eCNamedCurve.getECParameterSpec();
            if (f.put(string2, eCParameterSpec) != null) {
                throw new RuntimeException(z[3] + string2);
            }
            for (String string9 : stringArray = i.split(string)) {
                if (g.put(string9.trim(), eCParameterSpec) != null) {
                    throw new RuntimeException(z[2] + string9);
                }
                if (e.put(string9.trim(), string2) == null) continue;
                throw new RuntimeException(z[2] + string9);
            }
            int n4 = eCFieldFp.getFieldSize();
            if (n2 == 5 || n2 == 6 || h.get(n4) == null) {
                h.put(n4, eCParameterSpec);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(z[1], iOException);
        }
    }

    static {
        z = new String[]{ECNamedCurve.z(ECNamedCurve.z("\b\u001b1W{3R9_l&\u0016,\u0016h8\u0017\u007fXf>R,Cy:\u001d-Bl.")), ECNamedCurve.z(ECNamedCurve.z("\u0003\u001c+S{$\u00133\u0016l8\u00000D")), ECNamedCurve.z(ECNamedCurve.z("\u000e\u0007/Z`)\u0013+_f$R1Wd/H\u007f")), ECNamedCurve.z(ECNamedCurve.z("\u000e\u0007/Z`)\u0013+_f$R0_mpR")), ECNamedCurve.z(ECNamedCurve.z("\u0003\u001c)We#\u0016\u007fBp:\u0017e\u0016")), ECNamedCurve.z(ECNamedCurve.z("\u001e\u001a:\u0016F\u00036\u007fUf?\u001e;\u0016g%\u0006\u007fTlj6\u001ad$/\u001c<Ym/\u0016")), ECNamedCurve.z(ECNamedCurve.z("\u001e\u001a:\u0016h&\u00150D`>\u001a2\u0016g+\u001f:\u0016f8R\u0010\u007fMj\u0002-Y\u007f#\u0016:R)=\u0013,\u0016g%\u0006\u007fDl)\u001d8X`0\u0017;\u0016f8R6E)$\u001d+\u0016z?\u0002/Y{>\u0017;")), ECNamedCurve.z(ECNamedCurve.z("jZ")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj"))};
        e = new HashMap<String, String>();
        f = new LinkedHashMap<String, ECParameterSpec>();
        g = new HashMap<String, ECParameterSpec>();
        h = new HashMap<Integer, ECParameterSpec>();
        i = Pattern.compile(ECNamedCurve.z(ECNamedCurve.z("f\u000e\u0003mu\u0016/")));
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8{@-\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'|")), 1, ECNamedCurve.z(ECNamedCurve.z("\u000e0hu;\u000b0\u0019\u0000;\u000fAjs?|Jo\u0001?\b7\u001er;zJ\u001d")), ECNamedCurve.z(ECNamedCurve.z("\u000e0hu;\u000b0\u0019\u0000;\u000fAjs?|Jo\u0001?\b7\u001er;zJg")), ECNamedCurve.z(ECNamedCurve.z("|GfsOr0\u001e\u0006=yKn\u0000L\u000f6\u001a\u000e0{Ch\u0006;\b@m")), ECNamedCurve.z(ECNamedCurve.z("zKk\u000e>xAf\u000f0\u007f3jsL}D\u001d\u0003<\fK\u001c\u0004OzKg")), ECNamedCurve.z(ECNamedCurve.z("\u000bJfuL\u007f3\u0019\u000e>xF\u001c\u0006HxA\u001a\u0006Lz4\u0019\u0001>\u007fBo")), ECNamedCurve.z(ECNamedCurve.z("\u000e0hu;\u000b0\u0019\u0000;\u000fAjs>|@grO\u000b1i\u0003?{1j")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8{@-\u0004")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'}")), 1, ECNamedCurve.z(ECNamedCurve.z("\u000e0hu;\u000b0\u0019\u0000;\u000fAjs?|Jo\u0001?\b7\u001er;zJ\u001d")), ECNamedCurve.z(ECNamedCurve.z("|Cm\u0001JxF\u001c\u0006<\fAgw9\u000b3\u001ep?\u007f1osOz@\u001c")), ECNamedCurve.z(ECNamedCurve.z("\u007fC\u001bsO{Jn\u0003M\bG\u001ar>~4\u001cu:~1g\u0003M}Bf")), ECNamedCurve.z(ECNamedCurve.z("~0\u001e\u00059\u000b0js1s@\u001d\u0002L{Dk\u000fM\u000eBf\u00041|Fl")), ECNamedCurve.z(ECNamedCurve.z("+\u0016<R=|\u0014j\u000e1x\u0017l\u0001=}\u0016:P:|\u0017f\u0003?/Kh")), ECNamedCurve.z(ECNamedCurve.z("yD\u001bp9\u000b3\u0019r1\bJ\u001b\u0001<sE\u001cw8zGm\u0006MzF\u001d")), 4);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8xJ-\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'xJ")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u001bpO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u001bpO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f1")), ECNamedCurve.z(ECNamedCurve.z("\u000fJh\u0003>s1n\u00079}K\u0019\u0002:\u000e6g\u0004=sKlu;\t7\u001a\u0003L\u000eA")), ECNamedCurve.z(ECNamedCurve.z("{DnpO}Gm\u000eKrKft;\u000eB\u001c\u00041|BhuH\u007f@\u001c\u0003KrD")), ECNamedCurve.z(ECNamedCurve.z("\t4jwJrAf\u0003K\u000b4\u001at8y1o\u0004M\u000b@f\u0004M\u000e7\u001b\u0001HrA")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u001a\u00069zBo\u00069zEjw:z6nt0zAgw8{G")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8xJ-\u0004")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'xK")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u001bpO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4")), ECNamedCurve.z(ECNamedCurve.z("\u000eDo\u00058sKgr8\bA\u001dtO\u000f0\u0019\u00030\t1ftK\f4fwL\u000fC")), ECNamedCurve.z(ECNamedCurve.z("\u007f7\u001asO\t3l\u000e9\u000eBm\u000f8s6\u001c\u0004J|Gj\u000eK\bD\u001b\u000eH\u007f6")), ECNamedCurve.z(ECNamedCurve.z("}0iwH\u007f6g\u0003L\u007fEm\u000f1y7ipKy@\u001e\u0001J\u000e7\u001du8~B")), ECNamedCurve.z(ECNamedCurve.z("xE\u001d\u00000{D\u001e\u000e0~6lwL\u000fEn\u0006?\f7g\u0006<\f1l\u0002K~F")), ECNamedCurve.z(ECNamedCurve.z("y4\u0019pO\f4\u0019\u0001O\f4\u0019pO\f0\u001a\u00069xFh\u00049|Clt<\u000bA")), 4);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8|B4\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006's")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f3\u001c\u0001:")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u0006>")), ECNamedCurve.z(ECNamedCurve.z("y0ku:r@\u001cs:}3\u001e\u00070x3k\u00068s7h\u0000:zAip=\fG\u001br=\u000eE\u001atK")), ECNamedCurve.z(ECNamedCurve.z("sAguOsAj\u00058r4\u001buL\u000eD\u001du;r@g\u0000<yCh\u0005:\tA\u0019\u0006:\tF\u0019sL")), ECNamedCurve.z(ECNamedCurve.z("zCo\u00069zBo\u00069zBo\u00069zBo\u00069zC\u001d\u000eO\u000bCirO\u000b0fwJ\u000bCit?\bA")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8|B-\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'r")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4hpO\f4\u0019pO")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4hpO\f4\u0019pJ")), ECNamedCurve.z(ECNamedCurve.z("{1f\u0001K\u000f4\u001c\u0003=\b6hw1\bDjwJ\fJfp1{6kr=\u000b6\u001c\u0003?\u007f4\u001e\u0002<")), ECNamedCurve.z(ECNamedCurve.z("~3f\u0000K\u007fDg\u000eL\fGh\u0005;rFi\u0000=|Kg\u000f?r1l\u000eK\bKn\u0005J\b4\u001c\u000e;")), ECNamedCurve.z(ECNamedCurve.z("xA\u001e\u0000;rGj\u00058|Jf\u0002>\u000eGfrJ\tKn\u00049~@l\u00038yEhwJ\u007f4\u001d\u0005;")), ECNamedCurve.z(ECNamedCurve.z("zCo\u00069zBo\u00069zBo\u00069zBo\u00069zC\u0019\u0002Jr4f\u0004>\u000b7\u001b\u0005J\u000bEj\u0004;\u007fE")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8|B-\u0004")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'yB")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f3\u001c\u0001:")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f3\u001c\u00019")), ECNamedCurve.z(ECNamedCurve.z("\bF\u001a\u0007:~6lpK\u007fK\u001at1\b3\u001d\u0003>xEk\u000f9~Di\u0002M\u007f3\u0019\u00039yJgtH")), ECNamedCurve.z(ECNamedCurve.z("\u007f@\u001buKzAk\u00040y3n\u0007>\u000fC\u0019\u0002O\fCnt:z4h\u00070s6l\u0007=~1\u001a\u0000M")), ECNamedCurve.z(ECNamedCurve.z("\f7\u001epO\u000f4ms:yC\u0019\u00040|7o\u00018\f3orOsKg\u0004J\f7\u001e\u0001M~A\u0019\u0004L")), ECNamedCurve.z(ECNamedCurve.z("zCo\u00069zBo\u00069zBo\u00069zBo\u00069zBl\u00038\u000f7h\u000e?\u000bJn\u000eOy3nw8|0")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8s@4\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'yC")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pL\f4\u0019pL\u000fAh")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBl")), ECNamedCurve.z(ECNamedCurve.z("\u000e0kpO{B\u001au9\u007fE\u001a\u000fH\u000f@it9}6o\u00041z0hp=yFnrH\u007f6nt8\u000f3\u001a\u0006?\tE\u001b")), ECNamedCurve.z(ECNamedCurve.z("s0mp;\fD\u001b\u000fJ\u007fDm\u000eH}Jk\u00028|A\u001b\u00068\u007f0\u001a\u000e?yFk\u00061x3\u001e\u000e1\u000eKjs;\fK\u001b")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019s;|4mpJ{Eop?sFi\u0000H}F\u001bsO\u000eJ\u001b")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F8s@-\u0007)\u0011<\u0016e]j\"r\u00070x^\u007fn0dDm\u0016y8\u001b2S8s@)\u0007T")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0007")), 5, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001c")), ECNamedCurve.z(ECNamedCurve.z("|Fm\u00079\u007fCfs<s1g\u0006L}B\u0019w>\u000fK\u001et>x@k\u00059~K\u0019sKr6\u001asJ\tCk\u0000Ks0n")), ECNamedCurve.z(ECNamedCurve.z("{JgrHrB\u001at9yBf\u0006O|E\u001ctOxB\u001at=y3n\u000e1zB\u0019\u0002O\fB\u001epMr@\u0019p8zCm")), ECNamedCurve.z(ECNamedCurve.z("zEn\u000f;\bKjpO\tJ\u001bw>rDl\u00079{C\u001ar?\b@kuM\u000eGh\u0005OsEhw8{7h\u000f=rCn")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p0s6\u001ap1yDn\u0002?\b1ft8\bF\u001b\u0004;rAn")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F;xF4\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'y@")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001apO\f4\u001a\u0003?\u000e")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069z")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069\u007f")), ECNamedCurve.z(ECNamedCurve.z("\u000bCk\u0003<\bAl\u0002M\fBf\u000fM\fAopJxJ\u001e\u0007?s3k\u0000>\u000fK\u001a\u0002>zEjw0z4hs?\u007fB\u001at?\bE\u001e\u0002<\t")), ECNamedCurve.z(ECNamedCurve.z("}7o\u000e0\f7\u001b\u0001O\b3l\u0002=xJmuH\f0\u001b\u0000O}7l\u00070\fE\u001c\u0006Kz0\u001b\u00030\u000f@\u001cw=\b6\u001d\u0003<|6i\u0007H\u007f")), ECNamedCurve.z(ECNamedCurve.z("zCo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00068\u000e1\u001a\u000eMx7\u001c\u00008rF\u001cwOz3f\u00018}DfpK{4h")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F;xF-\u0007)\u0011<\u0016e]j\"r\u0004;~/")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'yA")), 5, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4o\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069{")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\u000f")), ECNamedCurve.z(ECNamedCurve.z("\bFo\u00039\u000bJj\u0006JzF\u001d\u0005H\b4j\u00028y@j\u0000<zFkt9\bE\u001b\u0001K\f6gtHxEot:sFl\u0004:\u007fG\u0019pK~")), ECNamedCurve.z(ECNamedCurve.z("\bEos9\t0\u001b\u0000K\bF\u001dp>\fAm\u0007:sB\u001d\u000f=\u000bBlu8\u000eAj\u0000JxCn\u0004;yFl\u00041z6i\u00078\u007f1nr;{")), ECNamedCurve.z(ECNamedCurve.z("\b6l\u0001?yJgt<\fEm\u0005O\bF\u001c\u0004;\u000e4\u001a\u0000J\u000eFl\u0001<\u000bBjw9}Fh\u0000=~F\u001b\u00031{Kf\u000e<zBhs:~")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019\u0007?\u000b@\u001a\u0006Kr4o\u0005L{A\u001br;sFj\u0003J\u007f1mw:\u000e")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F;\u007fD4\u0007")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'{B")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\u000f4\u0019pO\f1mp")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u0006")), ECNamedCurve.z(ECNamedCurve.z("zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u0001")), ECNamedCurve.z(ECNamedCurve.z("}K\u001ds?|E\u001ap0\u000e1\u001dtH\tGjw9|@f\u0003J\u000fJh\u0006KzEo\u00040\b4\u001crKx6\u001cs;r6f\u00030\f@g\u0007<\bCip1{Ef\u000e")), ECNamedCurve.z(ECNamedCurve.z("~JlwM\u000bEh\u0004?\u000bA\u001c\u0002?\u007fG\u001bw=\f0\u0019u9\u000fCn\u00061\u000bJ\u0019r8}0k\u00021\u000bDg\u0003<~Cf\u000fJ~E\u001b\u00061\f4\u001d\u00079\u000eF\u001d\u000e")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u001dwH\u000f6\u001cs?\u000b4k\u000eHzA\u001dtO\u000e@js1\t6o\u0005?~Ck\u0007")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F;\u007fD-\u0007)\u0011<\u0016e]j\"r\u0004<|^\u007fn0dDm\u0016y8\u001b2S;\u007fD)\u0007T")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0001")), 5, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019\u00069zBo\u00069{Bo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019\u00069zBo\u00069{Bo\u00069zBo\u00069zBo\u00069zBo\u00069zBo\u00069\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019u")), ECNamedCurve.z(ECNamedCurve.z("\u007f3\u001c\u0000:\u007f6gwHy3f\u0005L}0lsK\b6j\u0003>|Kg\u000e?\b1i\u00038\u000eBit9\t1j\u0005Kz4i\u0005K\t7lu:\u000f@hr;|Bkt")), ECNamedCurve.z(ECNamedCurve.z("|0n\u0001M{4ms8x1k\u0004=}4gtJ\u000fD\u001a\u0003?y3k\u00029\f@h\u00019yE\u001b\u000e8x6\u001at:y3op=\u000bCl\u000f=\u007f6g\u000f1\t@f\u0000")), ECNamedCurve.z(ECNamedCurve.z("~4\u001a\u0005=x7mpL{3hp0\bJ\u001as>\u000f0kw>\tB\u0019\u000fL{DmtJ\u000fAl\u0003>|0l\u0007<\u000f1\u001auK\bDk\u0006?rAhtO\u007fC\u0019\u0003")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019\u00069zBo\u00069z4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001duL|4\u001ewM\u000bEn\u00010\u000fJkp:\bK\u001cwJx4\u001c\u0000:xGj\u0007")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F:rF-\u0007)\u0011<\u0016e]j\"r\u00051~/")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'yF")), 5, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019sO\f4\u0019pO\f4o\u00069zBo\u00069zBo\u00069zBopO\f4\u0019pO\f")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019sO\f4\u0019pO\f4o\u00069zBo\u00069zBo\u00069zBopO\f4\u0019pO\t")), ECNamedCurve.z(ECNamedCurve.z("\bAl\u0007;\f3hs;y7\u001a\u0001L~Kg\u000eLzGitLy4g\u0004M{Kn\u000e8\u000eK\u001c\u0000L\f7g\u0007={Cm\u0006:{Fo\u000e1\fGo\u0007:rEjwJ|Gi\u00050r6gw;\u000f6n\u000fMx3g\u0003Jr7\u001br:\u000f1mwL\f")), ECNamedCurve.z(ECNamedCurve.z("\u000b3g\u0001J\u000b@mtLr0o\u0003:}J\u001at8\tEnsOy@owM}Fis8\u000eA\u001d\u0000;r0\u001e\u00010\bKg\u00030\fEk\u0007LzJm\u0003=x3l\u000e<\u007fBmp;\u007f6\u001dp<\u007f@f\u0000Jy3j\u0002<\u000fAg\u0001;}DowK}")), ECNamedCurve.z(ECNamedCurve.z("yDn\u0001M\u000fF\u001e\u000f?xDmu?\fG\u001b\u000fLsJ\u001dp0xKmrJxK\u0019\u000eO~C\u001btMxJfw8~E\u001cs0\u000e3l\u00078y0jp9\bJ\u001c\u00069\u000bDot8\t7nr>\u000fJn\u000fM}3k\u00058\u000eE\u001c\u000f9\u000f3os<\f")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019u>|Akr1{4k\u0005>x6\u001bp<rC\u001e\u0006M\b@k\u000eKz3h\u0001H\u000f1\u001au8sD\u001euJ\tGm\u000f>y")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("9\u0017<F<xC-\u0007)\u0011<\u0016e]j\"r\u0003;{/")), ECNamedCurve.z(ECNamedCurve.z("{\\l\u00188y@q\u0006'yG")), 5, ECNamedCurve.z(ECNamedCurve.z("zC\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4")), ECNamedCurve.z(ECNamedCurve.z("zC\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f1")), ECNamedCurve.z(ECNamedCurve.z("zBj\u00070\u007fA\u001at0|Cgs8\tK\u001e\u0007Os@fw;{3ot?rGk\u0006L\u000f3mrH}@jt0s0l\u0007<\fA\u001d\u000eK~Jf\u000f8r7\u0019\u00079s7n\u0003?{Kl\u000f<{7\u001c\u0001LsAht8|Gmu9\b6ltK{0\u0019\u0006>yGh\u0005M\fJg\u0005Mx1l\u0002O{7\u0019\u0002<{4\u001b\u0002?\bGo\u0005OzB")), ECNamedCurve.z(ECNamedCurve.z("zB\u001c\u00001\u007fJ\u001a\u0006?\bEo\u00029~7fuMs7lsJ\bDi\u0004:sG\u001d\u0002=xK\u001c\u0000=rCl\u000f9\u007fA\u0019t<xC\u0019\u000e;r3\u0019\u00009|0kr:\u000e0\u001ew8~0js>}7\u0019s>\u007fKm\u000eO\u000fC\u001bu8xE\u001e\u0004O\f3grLyAk\u000eKy1n\u000e<|3k\u00040\b4f\u0001L}7l\u0007Jx7jtM|D")), ECNamedCurve.z(ECNamedCurve.z("zCn\u000e:s@f\u0000H}Jfw:\b1o\u0006=\u007f1gw<\f0k\u0004J}6ntMsKgp<~Fk\u000f<}K\u001d\u0002=|Jn\u0001H\f0\u001b\u0007>xEls?|@\u001c\u000f>\u000f7h\u00040sG\u001ap=xDk\u0006J\u007fGot0zClpH\u000eBh\u00008yGlu>zJiw;}@\u001c\u0004=zJgtLsFh\u00000\f6n\u0000?\u007fB")), ECNamedCurve.z(ECNamedCurve.z("zC\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001e\u00038rDg\u00011y0\u0019\u0004OsDit>\f1\u001c\u00068~J\u0019\u00019s3jr9y0\u001d\u0003Js0g\u000e0s1k\u0001H\u000f0\u001d\u0000O\bEns0{Ag\u0000=zK")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0012Kq\u0000;j\u0002-_d/Cf\u0004\u007fx")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0004")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001c")), ECNamedCurve.z(ECNamedCurve.z("\t1m\u0004M|6\u0019t0\u007f1it;\u007f7k\u000fJz6i\u0005?~3ks<sJou:sA\u001ew;{Di\u000eMsGl")), ECNamedCurve.z(ECNamedCurve.z("\u000f7\u001e\u0004K\u000b7hs8~Kh\u000e=x4mrL}Ei\u000fJ\f7fu0rK\u001c\u0006>x3\u001b\u00000|4k\u000e9yF\u001e")), ECNamedCurve.z(ECNamedCurve.z("|Gh\u0002M{C\u001b\u00000\bD\u001au>\u000bDh\u0004K\bJmw9rA\u001bp;\f@\u001d\u00061~E\u001bs0}B\u001d\u0004M\u000fCj")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019s<\f0nw>xF\u001bu1zFn\u000e?~J\u001b\u000eM\u000eAn")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0012Kq\u0000;j\u0002-_d/Cf\u0004\u007fy")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0005")), 1, ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f7\u0019pO\f4\u0019pO\f4\u0019pO\f4\u001c")), ECNamedCurve.z(ECNamedCurve.z("x@n\u0004:\u000e1m\u00050\u007f3o\u0003J\u000b3h\u0002;y6\u001esJ\t1f\u0002>|B\u001e\u0001M~Dm\u0004<|0\u001b\u0003?sCi")), ECNamedCurve.z(ECNamedCurve.z("}6m\u000f>}Jn\u00069\tDjw8\u000e3n\u00011yEn\u0000<rJ\u001buLx0gt=\u000b7\u001a\u000eLx@gp8rKi")), ECNamedCurve.z(ECNamedCurve.z("yJ\u001e\u000f9\f@m\u0000:}Al\u0001:yF\u001d\u00020\u000e1\u001d\u0000?\u000bD\u001bu1\fKf\u00011\u000b1\u001e\u0001?~J\u001e\u000f=y0o")), ECNamedCurve.z(ECNamedCurve.z("\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\u000bDmr9yC\u001c\u000e:\fFm\u000f=\fDk\u0006L\tCl")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0012Kq\u0000;j\u0002-_d/@l\u000f\u007f{")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0002")), 1, ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pO")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pJ")), ECNamedCurve.z(ECNamedCurve.z("|0o\u0007?\tA\u001drJ\fCg\u000f={6or?\u007fFf\u00048~EjuH}C\u001e\u000fM\b@\u0019t;}6nr:}Ef\u00008rG\u001c\u00040~@\u001c\u0006H")), ECNamedCurve.z(ECNamedCurve.z("z4\u0019w0|A\u001crJ\u000bJg\u0007?\t1\u001c\u0005:\bJi\u0002;\b7\u001bp0zG\u001c\u0005MyGg\u0003>y6lp;}4\u001dtMy0luKs3\u001ewO")), ECNamedCurve.z(ECNamedCurve.z("}6\u001atLr7ks0z3jrH\u000fD\u001a\u00029\u007fF\u001cw<yB\u001dw9~Dj\u0002KyDg\u00071\t7m\u0004?\bAfpJ\t0ht9x4nwL")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pOs7js0\u000bK\u0019\u0003MsBh\u0007O\b6n\u0003;xDg\u000e0zK\u001b\u0006K")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0012Kq\u0000;j\u0002-_d/@l\u000f\u007fx")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0003")), 1, ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pO")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pJ")), ECNamedCurve.z(ECNamedCurve.z("|ChpH\bDg\u0005;\u007fEiuK\b4\u001ar<z6f\u000fOz@k\u000fJy4\u001as<r0f\u0002K\u000bBo\u00051\tE\u001es1~1gu1y@\u0019\u0004J")), ECNamedCurve.z(ECNamedCurve.z("yJ\u001ep9s6f\u000e>xEh\u0006<{@ou0xC\u001dt<\u000fK\u001a\u0004?xKiw:\t6\u001cp;\fAj\u0001<}3osH\f6g\u0001KrAos>")), ECNamedCurve.z(ECNamedCurve.z("\u007f0o\u0007;\u007f7krK\u000f3osJ}@o\u0000M\u000bB\u0019u9{6ft9rCl\u00040\f0j\u0003<\u000e7isO~Do\u0004:}6\u0019p1\b7ktH")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p1zBo\u00069\t4\u001e\u0001LrGf\u0002:}E\u001b\u00028~1o\u00051xC\u001du<r@o\u0000:")), 1);
        ECNamedCurve.a(ECNamedCurve.z(ECNamedCurve.z("\u0012Kq\u0000;j\u0002-_d/@l\u000f\u007fy")), ECNamedCurve.z(ECNamedCurve.z("{\\m\u00181~Bq\u00079zFj\u0018:dCq\u0000")), 1, ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pO")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pO\f4\u0019pO\fJo\u00069zBo\u00069zBo\u0001O\f4\u0019pO\f4\u0019pJ")), ECNamedCurve.z(ECNamedCurve.z("xGj\u00019\u007f4\u001e\u0004HyBi\u0000<~0np=\t0o\u0005M|3h\u00039\u000bAou;\u007fBn\u0006;\u000eFf\u000e1}Chr0\b3n\u0003H\bD\u001b\u0005L")), ECNamedCurve.z(ECNamedCurve.z("|Ei\u000eH\u000fJ\u001a\u00071\b0f\u0004J\f1\u0019\u00069\u007f1f\u00020\u000b3mu?\u000eKk\u000e<y6os?|B\u001dtOrGkt8\tKj\u0006<\f7f\u0003H")), ECNamedCurve.z(ECNamedCurve.z("{Do\u0001L|Jf\u000eOyKou9|0\u001c\u0007M\u007fGmtH\u000e@m\u0000Oy0ipJ\f7k\u000eK|7g\u00071~KfwO{J\u001a\u0005L\u000eD\u001cp:")), ECNamedCurve.z(ECNamedCurve.z("}4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019pO\f4\u0019p>\f4\u0019pOsEjrL\bFnt:\u000bDo\u0003>\tA\u001c\u0002:xCk\u0000<xDj\u00038")), 1);
        i = null;
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 9);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 74;
                        break;
                    }
                    case 1: {
                        n4 = 114;
                        break;
                    }
                    case 2: {
                        n4 = 95;
                        break;
                    }
                    case 3: {
                        n4 = 54;
                        break;
                    }
                    default: {
                        n4 = 9;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

