/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.model.converter;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDateTime;
import com.ibm.xml.xlxp2.jaxb.model.converter.JAXBModelConverter;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import javax.xml.datatype.XMLGregorianCalendar;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLGregorianCalendarDV
extends TypeValidator {
    public static final int INDETERMINATE = 999;
    public static final int EQUAL = 0;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = -1;
    protected static final int DEFAULT_YEAR = 2000;
    protected static final int DEFAULT_MONTH = 1;
    protected static final int DEFAULT_DAY = 1;
    protected static final int POSITION_YEAR = 0;
    protected static final int POSITION_MONTH = 1;
    protected static final int POSITION_DAY = 2;
    protected static final int POSITION_TIME = 3;
    public static final XMLGregorianCalendarDV INSTANCE = new XMLGregorianCalendarDV();
    private static final int SIGNED_INT_MULTMIN = -214748364;

    private XMLGregorianCalendarDV() {
        super(null, null, null, -1, -1, null, 0, false);
    }

    public XMLGregorianCalendarDV(String string, int n) {
        super(null, null, string, n, n, null, 0, false);
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        return xMLString.toString();
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.actualValue = xMLString.toString();
    }

    public static short compareDates(XDateTime xDateTime, XDateTime xDateTime2, boolean bl) {
        if (xDateTime == null || xDateTime2 == null) {
            return 999;
        }
        if (xDateTime.utc == xDateTime2.utc) {
            return XMLGregorianCalendarDV.compareOrder(xDateTime, xDateTime2);
        }
        XDateTime xDateTime3 = new XDateTime();
        xDateTime3.type = xDateTime.type;
        xDateTime3.position = xDateTime.position;
        if (xDateTime.utc == 90) {
            XMLGregorianCalendarDV.cloneDate(xDateTime2, xDateTime3);
            xDateTime3.timezoneHr = 14;
            xDateTime3.timezoneMin = 0;
            xDateTime3.utc = 43;
            XMLGregorianCalendarDV.normalize(xDateTime3);
            short s = XMLGregorianCalendarDV.compareOrder(xDateTime, xDateTime3);
            if (s == -1) {
                return s;
            }
            XMLGregorianCalendarDV.cloneDate(xDateTime2, xDateTime3);
            xDateTime3.timezoneHr = -14;
            xDateTime3.timezoneMin = 0;
            xDateTime3.utc = 45;
            XMLGregorianCalendarDV.normalize(xDateTime3);
            short s2 = XMLGregorianCalendarDV.compareOrder(xDateTime, xDateTime3);
            if (s2 == 1) {
                return s2;
            }
            return 999;
        }
        if (xDateTime2.utc == 90) {
            XMLGregorianCalendarDV.cloneDate(xDateTime, xDateTime3);
            xDateTime3.timezoneHr = -14;
            xDateTime3.timezoneMin = 0;
            xDateTime3.utc = 45;
            XMLGregorianCalendarDV.normalize(xDateTime3);
            short s = XMLGregorianCalendarDV.compareOrder(xDateTime3, xDateTime2);
            if (s == -1) {
                return s;
            }
            XMLGregorianCalendarDV.cloneDate(xDateTime, xDateTime3);
            xDateTime3.timezoneHr = 14;
            xDateTime3.timezoneMin = 0;
            xDateTime3.utc = 43;
            XMLGregorianCalendarDV.normalize(xDateTime3);
            short s3 = XMLGregorianCalendarDV.compareOrder(xDateTime3, xDateTime2);
            if (s3 == 1) {
                return s3;
            }
            return 999;
        }
        return 999;
    }

    protected static void cloneDate(XDateTime xDateTime, XDateTime xDateTime2) {
        xDateTime2.year = xDateTime.year;
        xDateTime2.month = xDateTime.month;
        xDateTime2.day = xDateTime.day;
        xDateTime2.hour = xDateTime.hour;
        xDateTime2.minute = xDateTime.minute;
        xDateTime2.second = xDateTime.second;
        xDateTime2.utc = xDateTime.utc;
        xDateTime2.timezoneHr = xDateTime.timezoneHr;
        xDateTime2.timezoneMin = xDateTime.timezoneMin;
    }

    public static void normalize(XDateTime xDateTime) {
        if (xDateTime.timezoneHr != 0 || xDateTime.timezoneMin != 0 || xDateTime.utc == 43 || xDateTime.utc == 45) {
            int n = -1;
            int n2 = xDateTime.minute + n * xDateTime.timezoneMin;
            int n3 = XMLGregorianCalendarDV.fQuotient(n2, 60);
            xDateTime.minute = XMLGregorianCalendarDV.mod(n2, 60, n3);
            n2 = xDateTime.hour + n * xDateTime.timezoneHr + n3;
            n3 = XMLGregorianCalendarDV.fQuotient(n2, 24);
            xDateTime.hour = XMLGregorianCalendarDV.mod(n2, 24, n3);
            xDateTime.day += n3;
            while (true) {
                n2 = XMLGregorianCalendarDV.maxDayInMonthFor(xDateTime.year, xDateTime.month);
                if (xDateTime.day < 1) {
                    xDateTime.day += XMLGregorianCalendarDV.maxDayInMonthFor(xDateTime.year, xDateTime.month - 1);
                    n3 = -1;
                } else {
                    if (xDateTime.day <= n2) break;
                    xDateTime.day -= n2;
                    n3 = 1;
                }
                n2 = xDateTime.month + n3;
                xDateTime.month = XMLGregorianCalendarDV.modulo(n2, 1, 13);
                xDateTime.year += XMLGregorianCalendarDV.fQuotient(n2, 1, 13);
                if (xDateTime.year != 0) continue;
                xDateTime.year = xDateTime.timezoneHr < 0 || xDateTime.timezoneMin < 0 ? 1 : -1;
            }
            xDateTime.utc = 90;
        }
    }

    protected static void resetDateObj(XDateTime xDateTime) {
        xDateTime.year = 0;
        xDateTime.month = 0;
        xDateTime.day = 0;
        xDateTime.hour = 0;
        xDateTime.minute = 0;
        xDateTime.second = 0.0;
        xDateTime.utc = 0;
        xDateTime.timezoneHr = 0;
        xDateTime.timezoneMin = 0;
    }

    protected static int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (XMLGregorianCalendarDV.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected static int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    protected static int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected static int modulo(int n, int n2, int n3) {
        int n4 = n - n2;
        int n5 = n3 - n2;
        return XMLGregorianCalendarDV.mod(n4, n5, XMLGregorianCalendarDV.fQuotient(n4, n5)) + n2;
    }

    protected static int fQuotient(int n, int n2, int n3) {
        return XMLGregorianCalendarDV.fQuotient(n - n2, n3 - n2);
    }

    protected static short compareOrder(XDateTime xDateTime, XDateTime xDateTime2) {
        if (xDateTime.position < 3) {
            if (xDateTime.position < 2) {
                if (xDateTime.position < 1) {
                    if (xDateTime.year < xDateTime2.year) {
                        return -1;
                    }
                    if (xDateTime.year > xDateTime2.year) {
                        return 1;
                    }
                }
                if (xDateTime.month < xDateTime2.month) {
                    return -1;
                }
                if (xDateTime.month > xDateTime2.month) {
                    return 1;
                }
            }
            if (xDateTime.day < xDateTime2.day) {
                return -1;
            }
            if (xDateTime.day > xDateTime2.day) {
                return 1;
            }
        }
        if (xDateTime.hour < xDateTime2.hour) {
            return -1;
        }
        if (xDateTime.hour > xDateTime2.hour) {
            return 1;
        }
        if (xDateTime.minute < xDateTime2.minute) {
            return -1;
        }
        if (xDateTime.minute > xDateTime2.minute) {
            return 1;
        }
        if (xDateTime.second < xDateTime2.second) {
            return -1;
        }
        if (xDateTime.second > xDateTime2.second) {
            return 1;
        }
        return 0;
    }

    protected static void append(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        if (n2 == 4) {
            if (n < 10) {
                stringBuffer.append("000");
            } else if (n < 100) {
                stringBuffer.append("00");
            } else if (n < 1000) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
        } else if (n2 == 2) {
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
        } else if (n != 0) {
            stringBuffer.append((char)n);
        }
    }

    protected static void append(StringBuffer stringBuffer, double d) {
        if (d < 0.0) {
            stringBuffer.append('-');
            d = -d;
        }
        if (d < 10.0) {
            stringBuffer.append('0');
        }
        stringBuffer.append(d);
    }

    public static int parseUYear(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        if (n < n2) {
            boolean bl = false;
            int n3 = -2147483647;
            int n4 = -214748364;
            byte by = byArray[n];
            if (by == 45) {
                bl = true;
                n3 = Integer.MIN_VALUE;
                if (++n < n2) {
                    by = byArray[n];
                }
            }
            int n5 = n;
            if (by >= 48 && by <= 57) {
                int n6 = 48 - by;
                while (++n5 < n2 && (by = byArray[n5]) >= 48 && by <= 57) {
                    int n7;
                    if (n6 >= n4 && (n6 *= 10) >= n3 + (n7 = by - 48)) {
                        n6 -= n7;
                        continue;
                    }
                    return -1;
                }
                if (n5 - n >= 4 && n6 != Integer.MIN_VALUE && n6 != 0) {
                    xDateTime2.year = bl ? n6 : -n6;
                    return n5;
                }
            }
        }
        return -1;
    }

    public static int parseUMonth(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2 && (n3 = n3 * 10 + (by - 48)) >= 1 && n3 <= 12) {
                xDateTime2.month = n3;
                return n;
            }
        }
        return -1;
    }

    public static int parseUDay(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2 && (n3 = n3 * 10 + (by - 48)) >= 1 && n3 <= XMLGregorianCalendarDV.maxDayInMonthFor(xDateTime2.year, xDateTime2.month)) {
                xDateTime2.day = n3;
                return n;
            }
        }
        return -1;
    }

    public static int parseUHour(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2 && (n3 = n3 * 10 + (by - 48)) <= 23) {
                xDateTime2.hour = n3;
                return n;
            }
        }
        return -1;
    }

    public static int parseUMinute(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2 && (n3 = n3 * 10 + by - 48) <= 59) {
                xDateTime2.minute = n3;
                return n;
            }
        }
        return -1;
    }

    public static int parseUSecond(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2 && (n3 = n3 * 10 + by - 48) <= 59) {
                xDateTime2.second = n3;
                return n;
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseUMilliseconds(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        if (n >= n2) return -1;
        byte by = byArray[n];
        if (by != 46) return n;
        if (++n >= n2) return -1;
        by = byArray[n];
        if (by < 48 || by > 57 || ++n >= n2) return -1;
        int n3 = by - 48;
        by = byArray[n];
        if (by >= 48 && by <= 57) {
            if (++n >= n2) return -1;
            n3 = n3 * 10 + by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57) {
                if (++n >= n2) return -1;
                xDateTime2.milliseconds = n3 = n3 * 10 + by - 48;
                return n;
            }
            xDateTime2.milliseconds = n3 *= 10;
            return n;
        }
        xDateTime2.milliseconds = n3 *= 100;
        return n;
    }

    public static int parseUTimeZone(byte[] byArray, DeserializationContext.XDateTime2 xDateTime2, int n, int n2) {
        if (n < n2) {
            byte by = byArray[n];
            if (by == 43 || by == 45) {
                boolean bl = by == 45;
                int n3 = 0;
                int n4 = 0;
                while (++n < n2) {
                    if (n4 > 2) {
                        return -1;
                    }
                    by = byArray[n];
                    if (by >= 48 && by <= 57) {
                        n3 *= 10;
                        n3 += by - 48;
                    } else {
                        if (by == 58) break;
                        return -1;
                    }
                    ++n4;
                }
                if (n3 > 14) {
                    return -1;
                }
                if (n4 != 2 || n >= n2) {
                    return -1;
                }
                int n5 = 0;
                n4 = 0;
                while (++n < n2) {
                    if (n4 > 2) {
                        return -1;
                    }
                    by = byArray[n];
                    if (by < 48 || by > 57) break;
                    n5 *= 10;
                    n5 += by - 48;
                    ++n4;
                }
                if (n3 == 14 & n5 != 0 || n5 > 59) {
                    return -1;
                }
                if (n4 != 2 || n >= n2) {
                    return -1;
                }
                xDateTime2.timezone = bl ? -n5 : (n5 += n3 * 60);
                return n;
            }
            if (by == 90) {
                if (++n >= n2) {
                    return -1;
                }
                xDateTime2.timezone = 0;
                return n;
            }
            return n;
        }
        return -1;
    }

    public static boolean validateDateTime(XDateTime xDateTime) {
        if (xDateTime.month < 1 || xDateTime.month > 12 || xDateTime.day > XMLGregorianCalendarDV.maxDayInMonthFor(xDateTime.year, xDateTime.month) || xDateTime.day < 1) {
            return false;
        }
        if (xDateTime.hour > 23 || xDateTime.hour < 0) {
            if (xDateTime.hour == 24 && xDateTime.minute == 0 && xDateTime.second == 0.0) {
                xDateTime.hour = 0;
                if (++xDateTime.day > XMLGregorianCalendarDV.maxDayInMonthFor(xDateTime.year, xDateTime.month)) {
                    xDateTime.day = 1;
                    if (++xDateTime.month > 12) {
                        xDateTime.month = 1;
                        if (++xDateTime.year == 0) {
                            xDateTime.year = 1;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        if (xDateTime.minute > 59 || xDateTime.minute < 0 || xDateTime.second > 60.0 || xDateTime.second < 0.0 || xDateTime.timezoneHr > 14 || xDateTime.timezoneHr < -14) {
            return false;
        }
        if ((xDateTime.timezoneHr == 14 || xDateTime.timezoneHr == -14) && xDateTime.timezoneMin != 0) {
            return false;
        }
        return xDateTime.timezoneMin <= 59 && xDateTime.timezoneMin >= -59;
    }

    public static int hashCode(XDateTime xDateTime) {
        int n = 0;
        if (xDateTime.position < 3) {
            if (xDateTime.position < 2) {
                if (xDateTime.position < 1) {
                    n = xDateTime.year;
                }
                n += xDateTime.month;
            }
            n += xDateTime.day;
        }
        return n + xDateTime.hour + xDateTime.minute + (int)xDateTime.second;
    }

    public boolean scanContent(ParsedEntity parsedEntity, XMLString xMLString, VMContext vMContext) {
        DeserializationContext deserializationContext = (DeserializationContext)vMContext.dvContext;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        boolean[] blArray = deserializationContext.getNormalizedArray();
        blArray[0] = true;
        if (n + 1 < n2 && byArray[n] == 60 && byArray[n + 1] == 47) {
            xMLString.setValues(parsedEntity.buffer, n, n);
            vMContext.setContentScanner(null);
            return true;
        }
        DeserializationContext.XDateTime2 xDateTime2 = deserializationContext.getXDateTime2();
        n = XMLGregorianCalendarDV.parseDateTimeUnbuffered(parsedEntity, xDateTime2, blArray);
        if (n == -1 || byArray[n] != 60 || n + 2 >= n2 || byArray[n + 1] != 47) {
            vMContext.setContentScanner(null);
            return vMContext.scanContent();
        }
        parsedEntity.offset = n;
        deserializationContext.elementContentDeserialized = true;
        vMContext.isValidated = true;
        vMContext.setEntityContent(parsedEntity);
        vMContext.setContentScanner(null);
        XMLGregorianCalendar xMLGregorianCalendar = deserializationContext.datatypeFactory.newXMLGregorianCalendar(xDateTime2.year, xDateTime2.month, xDateTime2.day, xDateTime2.hour, xDateTime2.minute, xDateTime2.second, xDateTime2.milliseconds, xDateTime2.timezone);
        deserializationContext.currentStub.write(deserializationContext.currentPropertyId, xMLGregorianCalendar);
        return true;
    }

    private static int parseDateTimeUnbuffered(ParsedEntity parsedEntity, DeserializationContext.XDateTime2 xDateTime2, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUYear(byArray, xDateTime2, n, n2)) == -1 || byArray[n] != 45 || ++n >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUMonth(byArray, xDateTime2, n, n2)) == -1 || byArray[n] != 45 || ++n >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUDay(byArray, xDateTime2, n, n2)) == -1 || byArray[n] != 84 || ++n >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUHour(byArray, xDateTime2, n, n2)) == -1 || byArray[n] != 58 || ++n >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUMinute(byArray, xDateTime2, n, n2)) == -1 || byArray[n] != 58 || ++n >= n2) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUSecond(byArray, xDateTime2, n, n2)) == -1) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUMilliseconds(byArray, xDateTime2, n, n2)) == -1) {
            return -1;
        }
        if ((n = XMLGregorianCalendarDV.parseUTimeZone(byArray, xDateTime2, n, n2)) == -1) {
            return -1;
        }
        if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        return n;
    }
}

