/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.DataBufferHelper;
import com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.DataSource;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.Reader;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class CharacterStreamDataSource
implements DataSource {
    public int bufferLength;
    public boolean normalizeLineBreaks;
    public boolean isXML10;
    public int bufferLoadFactor;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private CharacterStreamDataSource fNextFreeDataSource;
    private DataSourceFactory fSourceFactory;
    private DataBufferFactory fBufferFactory;
    private Reader fReader;
    private char[] fReadBuffer;
    private int fReadOffset;
    private int fReadLimit;
    private int fReadLength;

    public CharacterStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n, int n2) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.bufferLength = n;
        this.fReadLength = n;
        this.fReadBuffer = ArrayAllocator.newCharArray(this.fReadLength + 1);
        this.bufferLoadFactor = n2;
    }

    public void setNextFreeDataSource(CharacterStreamDataSource characterStreamDataSource) {
        this.fNextFreeDataSource = characterStreamDataSource;
    }

    public CharacterStreamDataSource getNextFreeDataSource() {
        return this.fNextFreeDataSource;
    }

    public void setCharacterStream(Reader reader) {
        this.fReader = reader;
        this.isXML10 = true;
        this.fReadLimit = 0;
        this.fReadOffset = 0;
    }

    public int readMoreChars() throws IOException {
        int n;
        int n2 = this.fReadLength;
        if (this.fReadOffset == n2) {
            this.fReadLength <<= 1;
            this.fReadBuffer = ArrayAllocator.resizeCharArray(this.fReadBuffer, this.fReadLength + 1);
            n2 = this.fReadLength;
        }
        if ((n = this.fReader.read(this.fReadBuffer, this.fReadOffset, n2 - this.fReadOffset)) == -1) {
            this.fReader.close();
            this.fReader = null;
            return -1;
        }
        this.fReadLimit += n;
        return this.fReadBuffer[this.fReadOffset++];
    }

    public int readChar() throws IOException {
        if (this.fReadOffset < this.fReadLimit) {
            return this.fReadBuffer[this.fReadOffset++];
        }
        return this.readMoreChars();
    }

    public CharConversionError loadFromCharacterStream(ParsedEntity parsedEntity) {
        this.fReadOffset = this.fReadLimit;
        return this.load(parsedEntity);
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer(this.bufferLength + 1);
        dataBuffer.endOffset = this.bufferLength;
        parsedEntity.error = this.load(dataBuffer);
        int n = dataBuffer.endOffset;
        dataBuffer.bytes[n] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.fReader == null && this.fReadOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
                this.fReader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fSourceFactory.releaseCharacterStreamDataSource(this);
    }

    private CharConversionError load(DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = dataBuffer.endOffset;
        int n2 = 0;
        try {
            int n3;
            int n4;
            int n5 = 0;
            if (this.fReader != null && this.fReadOffset < this.fReadLength) {
                n4 = this.fReadLength - this.fReadOffset;
                n3 = this.fReader.read(this.fReadBuffer, this.fReadOffset, n4);
                if (n3 == -1) {
                    this.fReader.close();
                    this.fReader = null;
                    if (this.fReadOffset == 0) {
                        dataBuffer.endOffset = n2;
                        return null;
                    }
                } else {
                    int n6 = n4 >> this.bufferLoadFactor;
                    while (n3 < n6) {
                        int n7 = this.fReadOffset + n3;
                        int n8 = this.fReader.read(this.fReadBuffer, n7, n4 - n3);
                        if (n8 == -1) {
                            this.fReader.close();
                            this.fReader = null;
                            break;
                        }
                        n3 += n8;
                    }
                    n5 = n3;
                }
            }
            n5 += this.fReadOffset;
            this.fReadOffset = 0;
            while (this.fReadOffset < n5 && n2 < n) {
                if ((n4 = this.fReadBuffer[this.fReadOffset++]) < 128) {
                    if (n4 != 13) {
                        byArray[n2++] = (byte)n4;
                        continue;
                    }
                    if (this.fReadOffset < n5) {
                        byArray[n2++] = 10;
                        if ((n4 = this.fReadBuffer[this.fReadOffset++]) == 10 || !this.isXML10 && n4 == 133) continue;
                        --this.fReadOffset;
                        continue;
                    }
                    if (this.fReader == null) {
                        byArray[n2++] = 10;
                        break;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (!(this.isXML10 || n4 != 133 && n4 != 8232)) {
                    byArray[n2++] = 10;
                    continue;
                }
                if (n4 < 2048) {
                    if (n2 + 1 < n) {
                        byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                        continue;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (n4 < 55296 || n4 >= 57344) {
                    if (n2 + 2 < n) {
                        byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                        continue;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (n4 < 56320) {
                    if (this.fReadOffset < n5 && n2 + 3 < n) {
                        if ((n3 = this.fReadBuffer[this.fReadOffset++]) >= 56320 && n3 < 57344) {
                            n4 = 65536 + (n4 - 55296 << 10) + (n3 - 56320);
                            byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                            continue;
                        }
                        --this.fReadOffset;
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    --this.fReadOffset;
                    break;
                }
                --this.fReadOffset;
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (this.fReadOffset < n5) {
                System.arraycopy(this.fReadBuffer, this.fReadOffset, this.fReadBuffer, 0, n5 -= this.fReadOffset);
                this.fReadOffset = n5;
            } else {
                this.fReadOffset = 0;
            }
            dataBuffer.endOffset = n2;
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }
}

