/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.factory;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.injectionengine.factory.EnvEntryInfo;
import com.ibm.ws.injectionengine.factory.EnvEntryInfoRefAddr;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class EnvEntryObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = EnvEntryObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(EnvEntryObjectFactory.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private static final ThreadContextAccessor svThreadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());

    private static Reference createReference(String referenceClassName, String name, ComponentNameSpaceConfiguration compNSConfig, String className, String valueName) {
        EnvEntryInfo info = new EnvEntryInfo(name, compNSConfig.getApplicationName(), compNSConfig.getModuleName(), compNSConfig.getDisplayName(), className, valueName);
        return new Reference(referenceClassName, new EnvEntryInfoRefAddr(info), CLASS_NAME, null);
    }

    public static Reference createClassReference(String name, ComponentNameSpaceConfiguration compNSConfig, String className) {
        return EnvEntryObjectFactory.createReference("java.lang.Class", name, compNSConfig, className, null);
    }

    public static Reference createEnumReference(String name, ComponentNameSpaceConfiguration compNSConfig, String className, String valueName) {
        return EnvEntryObjectFactory.createReference(className, name, compNSConfig, className, valueName);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Class<?> result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance: " + obj), (Object[])new Object[0]);
        }
        if (!(obj instanceof Reference)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance: not a reference: " + Util.identity((Object)obj)));
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance: wrong factory: " + ref));
            }
            return null;
        }
        RefAddr addr = ref.get("EnvEntryInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + nex));
            }
            throw nex;
        }
        EnvEntryInfo info = (EnvEntryInfo)addr.getContent();
        String className = info.ivClassName;
        if (className == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance: missing type: " + ref));
            }
            if (info.ivName != null) {
                throw new IllegalStateException("The " + info.ivName + " env-entry was declared without a type by the " + info.ivComponentName + " component in the " + info.ivModuleName + " module of the " + info.ivApplicationName + " application.");
            }
            throw new IllegalStateException("The env-entry was declared without a type.");
        }
        ClassLoader classLoader = svThreadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
        Class<?> klass = classLoader.loadClass(info.ivClassName);
        if (info.ivValueName == null) {
            result = klass;
        } else {
            Object enumValue = Enum.valueOf(klass, info.ivValueName);
            result = enumValue;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance");
        }
        return result;
    }
}

