/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tls.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import io.openliberty.netty.internal.tls.impl.handler.LibertySslHandler;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"io.openliberty.netty.internal.tls"}, immediate=true, service={NettyTlsProvider.class})
public class NettyTlsProviderImpl
implements NettyTlsProvider {
    private static final TraceComponent tc = Tr.register(NettyTlsProviderImpl.class, null, null);
    static final String ALIAS_KEY = "alias";
    static final String SSLPROP_CLIENT_AUTHENTICATION = "com.ibm.ssl.clientAuthentication";
    static final String SSLPROP_CLIENT_AUTHENTICATION_SUPPORTED = "com.ibm.ssl.clientAuthenticationSupported";
    private static final String SSLSESSION_CACHE_SIZE = "SSLSessionCacheSize";
    private static final String SSLSESSION_TIMEOUT = "SSLSessionTimeout";
    private static final String SSLSESSION_TIMEOUT_8500 = "sessionTimeout";
    private static final String DEFAULT_SSLSESSION_CACHE_SIZE = "100";
    private static final String DEFAULT_SSLSESSION_TIMEOUT = "86400";
    static final long serialVersionUID = 3133906566910860881L;

    @Activate
    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl activate " + this), (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl modified " + this), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl deactivate " + this), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler getOutboundSSLContext(Map<String, Object> sslOptions, String host, String port, Channel channel) {
        String[] protocols;
        SSLConfig sslConfig;
        SSLContext jdkContext;
        try {
            Properties props = NettyTlsProviderImpl.createProps(sslOptions);
            String alias = props.getProperty(ALIAS_KEY);
            AbstractMap.SimpleEntry<SSLContext, SSLConfig> sslContextConfigPair = NettyTlsProviderImpl.getSSLContextAndConfig(alias, props, true, host, port, port, false);
            if (sslContextConfigPair == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"getInboundALPNSSLContext exception caught creating SSLContext", (Object[])new Object[0]);
                }
                return null;
            }
            jdkContext = sslContextConfigPair.getKey();
            sslConfig = sslContextConfigPair.getValue();
            String protocol = sslConfig.getProperty("com.ibm.ssl.protocol");
            protocols = this.getSSLProtocol(protocol);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getOutboundSSLContext SSLContext:", (Object[])new Object[]{jdkContext});
            }
        }
        catch (Exception props) {
            FFDCFilter.processException((Throwable)props, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"150", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getOutboundSSLContext exception caught creating SSLContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        try {
            JdkSslContext nettyContext = new JdkSslContext(jdkContext, true, Arrays.asList(jdkContext.getDefaultSSLParameters().getCipherSuites()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, null, this.getClientAuth(sslConfig), protocols, false);
            this.preConfigureSslContext(sslConfig, (SslContext)nettyContext);
            return new LibertySslHandler(nettyContext.newEngine(channel.alloc()), sslOptions, channel);
        }
        catch (Exception nettyContext) {
            FFDCFilter.processException((Throwable)nettyContext, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"162", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getOutboundSSLContext exception caught creating JdkSslContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler getInboundSSLContext(Map<String, Object> sslOptions, String host, String port, Channel channel) {
        String[] protocols;
        SSLConfig sslConfig;
        SSLContext jdkContext;
        try {
            Properties props = NettyTlsProviderImpl.createProps(sslOptions);
            String alias = props.getProperty(ALIAS_KEY);
            AbstractMap.SimpleEntry<SSLContext, SSLConfig> sslContextConfigPair = NettyTlsProviderImpl.getSSLContextAndConfig(alias, props, true, host, port, port, false);
            if (sslContextConfigPair == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"getInboundALPNSSLContext exception caught creating SSLContext", (Object[])new Object[0]);
                }
                return null;
            }
            jdkContext = sslContextConfigPair.getKey();
            sslConfig = sslContextConfigPair.getValue();
            String protocol = sslConfig.getProperty("com.ibm.ssl.protocol");
            protocols = this.getSSLProtocol(protocol);
        }
        catch (Exception props) {
            FFDCFilter.processException((Throwable)props, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"198", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundSSLContext exception caught creating SSLContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInboundSSLContext SSLContext: " + jdkContext), (Object[])new Object[0]);
        }
        try {
            JdkSslContext nettyContext = new JdkSslContext(jdkContext, false, Arrays.asList(jdkContext.getDefaultSSLParameters().getCipherSuites()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, null, this.getClientAuth(sslConfig), protocols, false);
            this.preConfigureSslContext(sslConfig, (SslContext)nettyContext);
            return new LibertySslHandler(nettyContext.newEngine(channel.alloc()), sslOptions, channel);
        }
        catch (Exception nettyContext) {
            FFDCFilter.processException((Throwable)nettyContext, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"212", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundSSLContext exception caught creating JdkSslContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler getInboundALPNSSLContext(Map<String, Object> sslOptions, String host, String port, Channel channel) {
        String[] protocols;
        SSLConfig sslConfig;
        SSLContext jdkContext;
        try {
            Properties props = NettyTlsProviderImpl.createProps(sslOptions);
            String alias = props.getProperty(ALIAS_KEY);
            AbstractMap.SimpleEntry<SSLContext, SSLConfig> sslContextConfigPair = NettyTlsProviderImpl.getSSLContextAndConfig(alias, props, true, host, port, port, false);
            if (sslContextConfigPair == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"getInboundALPNSSLContext exception caught creating SSLContext", (Object[])new Object[0]);
                }
                return null;
            }
            jdkContext = sslContextConfigPair.getKey();
            sslConfig = sslContextConfigPair.getValue();
            String protocol = sslConfig.getProperty("com.ibm.ssl.protocol");
            protocols = this.getSSLProtocol(protocol);
        }
        catch (Exception props) {
            FFDCFilter.processException((Throwable)props, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"249", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundALPNSSLContext exception caught creating SSLContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInboundALPNSSLContext SSLContext: " + jdkContext), (Object[])new Object[0]);
        }
        try {
            ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
            JdkSslContext nettyContext = new JdkSslContext(jdkContext, false, Arrays.asList(jdkContext.getDefaultSSLParameters().getCipherSuites()), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, apn, this.getClientAuth(sslConfig), protocols, false);
            this.preConfigureSslContext(sslConfig, (SslContext)nettyContext);
            return new LibertySslHandler(nettyContext.newEngine(channel.alloc()), sslOptions, channel);
        }
        catch (Exception apn) {
            FFDCFilter.processException((Throwable)apn, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"270", (Object)this, (Object[])new Object[]{sslOptions, host, port, channel});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundALPNSSLContext exception caught creating JdkSslContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private void preConfigureSslContext(SSLConfig config, SslContext nettyContext) throws NettyException {
        int sslSessionCacheSize = this.getSslSessionCacheSize(config);
        if (sslSessionCacheSize == -1) {
            throw new NettyException("Found invalid value for SSLSessionCacheSize!");
        }
        int sslSessionTimeout = this.getSslSessionTimeout(config);
        if (sslSessionTimeout == -1) {
            throw new NettyException("Found invalid value for SSLSessionTimeout!");
        }
        sslSessionTimeout = (int)TimeUnit.MILLISECONDS.toSeconds(sslSessionTimeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property sslSessionTimout converted to seconds: " + sslSessionTimeout), (Object[])new Object[0]);
        }
        nettyContext.sessionContext().setSessionCacheSize(sslSessionCacheSize);
        nettyContext.sessionContext().setSessionTimeout(sslSessionTimeout);
    }

    @ManualTrace
    private String[] getSSLProtocol(String protocol) {
        String[] protocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLProtocol", (Object[])new Object[0]);
        }
        if ((protocols = protocol.split(",")).length == 1 && (protocols[0].equals("TLS") || protocols[0].equals("SSL"))) {
            protocols = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLProtocol " + protocols));
        }
        return protocols;
    }

    private ClientAuth getClientAuth(SSLConfig config) {
        boolean clientAuth = this.getBooleanProperty(SSLPROP_CLIENT_AUTHENTICATION, (Properties)config);
        if (clientAuth) {
            return ClientAuth.REQUIRE;
        }
        if (this.getBooleanProperty(SSLPROP_CLIENT_AUTHENTICATION_SUPPORTED, (Properties)config)) {
            return ClientAuth.OPTIONAL;
        }
        return ClientAuth.NONE;
    }

    private int getSslSessionTimeout(SSLConfig sslConfig) {
        String sslSessionTimeout = String.valueOf(sslConfig.getOrDefault((Object)SSLSESSION_TIMEOUT, (Object)DEFAULT_SSLSESSION_TIMEOUT));
        try {
            int parsedValue = Integer.parseInt(sslSessionTimeout);
            return parsedValue;
        }
        catch (NumberFormatException parsedValue) {
            FFDCFilter.processException((Throwable)parsedValue, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"339", (Object)this, (Object[])new Object[]{sslConfig});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property SSLSessionTimeout, format error in [" + sslSessionTimeout + "]"), (Object[])new Object[0]);
            }
            return -1;
        }
    }

    private int getSslSessionCacheSize(SSLConfig sslConfig) {
        String sslSessionCacheSize = String.valueOf(sslConfig.getOrDefault((Object)SSLSESSION_CACHE_SIZE, (Object)DEFAULT_SSLSESSION_CACHE_SIZE));
        try {
            int parsedValue = Integer.parseInt(sslSessionCacheSize);
            return parsedValue;
        }
        catch (NumberFormatException parsedValue) {
            FFDCFilter.processException((Throwable)parsedValue, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"360", (Object)this, (Object[])new Object[]{sslConfig});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property SSLSessionCacheSize, format error in [" + sslSessionCacheSize + "]"), (Object[])new Object[0]);
            }
            return -1;
        }
    }

    private boolean getBooleanProperty(String propertyName, Properties sslConfig) {
        boolean booleanValue = false;
        Object objectValue = sslConfig.get(propertyName);
        if (objectValue != null) {
            if (objectValue instanceof Boolean) {
                booleanValue = (Boolean)objectValue;
            } else if (objectValue instanceof String) {
                booleanValue = Boolean.parseBoolean((String)objectValue);
            }
        }
        return booleanValue;
    }

    @FFDCIgnore(value={Exception.class})
    private static AbstractMap.SimpleEntry<SSLContext, SSLConfig> getSSLContextAndConfig(String alias, Properties properties, boolean isInbound, String host, String port, String endPoint, Boolean isZWebContainerChain) throws Exception {
        String sslType;
        boolean useJSSEHelper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("host=" + host + " port=" + port + " endPoint=" + endPoint), (Object[])new Object[0]);
        }
        String direction = isInbound ? "inbound" : "outbound";
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", direction);
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        connectionInfo.put("com.ibm.ssl.endPointName", endPoint);
        Properties props = null;
        boolean bl = useJSSEHelper = null != alias;
        if (!useJSSEHelper) {
            block23: {
                try {
                    props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                        static final long serialVersionUID = 5971460751150327018L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Properties run() throws Exception {
                            return JSSEHelper.getInstance().getSSLPropertiesOnThread();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl$1", 1.class, null, null);
                        }
                    });
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception looking for on-thread props; e=" + e), (Object[])new Object[0]);
                }
            }
            if (null == props || 0 == props.size()) {
                props = null;
                useJSSEHelper = !properties.containsKey("com.ibm.ssl.keyStore") || !properties.containsKey("com.ibm.ssl.trustStore");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found on-thread ssl properties", (Object[])new Object[0]);
            }
        }
        if (useJSSEHelper) {
            try {
                final String aliasFinal = alias;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Querying security service for alias=[" + aliasFinal + "]"), (Object[])new Object[0]);
                }
                props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                    static final long serialVersionUID = -1083402093114087687L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Properties run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(aliasFinal, connectionInfo, null);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl$2", 2.class, null, null);
                    }
                });
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception getting SSL properties from alias: " + alias), (Object[])new Object[0]);
                }
                throw e;
            }
        }
        if (null != props) {
            properties.putAll((Map<?, ?>)props);
        }
        if (null != (sslType = (String)(props = properties).get("com.ibm.ssl.sslType"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSLConfig type: " + sslType), (Object[])new Object[0]);
            }
            if (sslType.equals("SSSL")) {
                throw new Exception("Invalid SSLConfig type: " + sslType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSL configuration <null value means non-string>:", (Object[])new Object[0]);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (-1 == key.toLowerCase().indexOf("password")) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + key + " = " + value), (Object[])new Object[0]);
                    continue;
                }
                StringBuilder output = new StringBuilder(4 + key.length() + value.length());
                output.append("\t").append(key).append(" = ");
                for (int i = 0; i < value.length(); ++i) {
                    output.append("*");
                }
                Tr.debug((TraceComponent)tc, (String)output.toString(), (Object[])new Object[0]);
            }
        }
        SSLContext context = null;
        SSLConfig config = null;
        try {
            config = new SSLConfig(props);
            context = JSSEHelper.getInstance().getSSLContext(connectionInfo, (Properties)config);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLContext from properties.", (Object[])new Object[]{e});
            }
            return null;
        }
        return new AbstractMap.SimpleEntry<SSLContext, SSLConfig>(context, config);
    }

    private static Properties createProps(Map<String, Object> map) {
        Properties properties = new Properties();
        boolean realTimeoutSet = false;
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(SSLSESSION_CACHE_SIZE)) {
                    properties.put(SSLSESSION_CACHE_SIZE, entry.getValue());
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase(SSLSESSION_TIMEOUT)) {
                    properties.put(SSLSESSION_TIMEOUT, entry.getValue());
                    realTimeoutSet = true;
                    continue;
                }
                if (!realTimeoutSet && entry.getKey().equalsIgnoreCase(SSLSESSION_TIMEOUT_8500)) {
                    properties.put(SSLSESSION_TIMEOUT, entry.getValue());
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }
}

