/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.impl.SchemaStoreItemStream;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class SchemaStoreItem
extends Item {
    private static TraceComponent tc = SibTr.register(SchemaStoreItem.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private JMFSchema schema;
    private SchemaStoreItemStream stream;

    public SchemaStoreItem() {
    }

    SchemaStoreItem(JMFSchema schema) {
        this.schema = schema;
    }

    @Override
    public int getStorageStrategy() {
        return 4;
    }

    @Override
    public void eventPostCommitRemove(Transaction tran) throws SevereMessageStoreException {
        super.eventPostCommitRemove(tran);
        if (this.stream != null) {
            this.stream.removeFromIndex(this);
        }
    }

    @Override
    public List<DataSlice> getPersistentData() {
        ArrayList<DataSlice> slices = new ArrayList<DataSlice>(1);
        slices.add(new DataSlice(this.schema.toByteArray()));
        return slices;
    }

    public int getInMemorySize() {
        return this.schema.toByteArray().length;
    }

    @Override
    public void restore(List<DataSlice> slices) {
        this.schema = JMFRegistry.instance.createJMFSchema(slices.get(0).getBytes());
    }

    JMFSchema getSchema() {
        return this.schema;
    }

    void setStream(SchemaStoreItemStream stream) {
        this.stream = stream;
    }
}

