/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.security.CollectiveDNUtil;
import com.ibm.ws.collective.utility.ICertificateUtility;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.CertificateUtility;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.EncodingProperty;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class CreateTask
extends BaseCommandTask {
    private static final String className = CreateTask.class.getName();
    private static final List<String> BETA_ARG_TABLE = Arrays.asList("--base64Key", "--aesConfigFile");
    private static final List<String> BETA_OPTS = BETA_ARG_TABLE.stream().map(s -> s.startsWith("--") ? s.substring(2) : s).collect(Collectors.toList());
    protected Collection<String> pwdArgs = new HashSet<String>();
    private ICertificateUtility certUtil;
    private File collectiveResourcesDir;
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;

    protected void setCertUtil(ICertificateUtility certUtil) {
        this.certUtil = certUtil;
    }

    private ICertificateUtility createCertificateUtility() throws TaskErrorException {
        try {
            Constructor ctor = CertificateUtility.class.getDeclaredConstructor(PrintStream.class, PrintStream.class);
            ctor.setAccessible(true);
            return (ICertificateUtility)ctor.newInstance(System.out, System.err);
        }
        catch (Throwable ex) {
            Trlog.debug(className, "createCertificateUtility", "Requested operation not available with this edition of WebSphere" + ex.getMessage());
            this.abort(this.getMessage("create.certUtil.NotAvailable", ex));
            return null;
        }
    }

    private ICertificateUtility certUtil() throws TaskErrorException {
        if (this.certUtil == null) {
            this.certUtil = this.createCertificateUtility();
        }
        return this.certUtil;
    }

    public CreateTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil) {
        super(scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.pwdArgs.add("--serverIdentityKeystorePassword");
        this.pwdArgs.add("--collectiveTrustKeystorePassword");
        this.pwdArgs.add("--httpsKeystorePassword");
        this.pwdArgs.add("--httpsTruststorePassword");
        this.pwdArgs.add("--rootKeystorePassword");
        this.confirmedArgs.add("--keystorePassword");
        this.confirmedArgs.add("--serverIdentityKeystorePassword");
        this.confirmedArgs.add("--collectiveTrustKeystorePassword");
        this.confirmedArgs.add("--httpsKeystorePassword");
        this.confirmedArgs.add("--httpsTruststorePassword");
        this.confirmedArgs.add("--rootKeystorePassword");
        this.confirmedArgs.add("--sshPrivateKeyPassword");
        this.flagArgs.add("--createConfigFile");
        this.flagArgs.add("--trace");
        this.noValueRequiredArgs.add("--setupSAF");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.addAll(this.noValueRequiredArgs);
        this.knownArgs.add("--collectiveName");
        this.knownArgs.add("--rootCertificateValidity");
        this.knownArgs.add("--serverIdentityCertificateValidity");
        this.knownArgs.add("--httpsCertificateSubject");
        this.knownArgs.add("--httpsCertificateValidity");
        this.knownArgs.add("--hostName");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        if (ProductInfo.getBetaEdition()) {
            this.knownArgs.add("--base64Key");
            this.knownArgs.add("--aesConfigFile");
        }
        this.knownArgs.add("--sshPublicKey");
        this.knownArgs.add("--sshPrivateKey");
        this.knownArgs.add("--safKeyring");
        this.knownArgs.add("--safCertificateLabel");
        this.knownArgs.add("--safKeystoreType");
        this.knownArgs.add("--safKeystoreProvider");
        this.knownArgs.add("--certificateRdn");
        this.knownArgs.add("--serverIdentityKeystore");
        this.knownArgs.add("--serverIdentityKeystoreAlias");
        this.knownArgs.add("--collectiveTrustKeystore");
    }

    @Override
    public String getTaskName() {
        return "create";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("create.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.s", "certProps.option-desc.s") + this.buildScriptOptions("certProps.option-key.c", "certProps.option-desc.c") + this.buildScriptOptions("certProps.option-key.h", "certProps.option-desc.h") + this.buildScriptOptions("create.option-key.", "create.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("common.option-key.", "common.option-desc.");
        return this.getTaskHelp("create.desc", "create.usage.options", "keystore5.option-key.", "keystore5.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("create.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            Trlog.debug(className, "abortAndPerform", "Recursive deletion of the directory " + collectiveResourcesDir + " failed");
            this.stdout.println(this.getMessage("create.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    private void abortAndPerformCleanup(String message, File collectiveResourcesDir, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("create.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(collectiveResourcesDir)) {
            Trlog.debug(className, "abortAndPerform", "Recursive deletion of the directory " + collectiveResourcesDir + " failed");
            this.stdout.println(this.getMessage("create.cleanupFail", collectiveResourcesDir));
        }
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        boolean checkInDefaultsDir;
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        boolean keyStorePwdUsed = false;
        String predType = "FILE";
        String configXML = "";
        if (args.length >= 3) {
            keyStorePwdUsed = this.isKeystorePwdUsed(args, this.pwdArgs);
            predType = this.customArgsFound(args);
        }
        if (predType.equals("FILE")) {
            if (this.pwdArgs.size() == 5 && !keyStorePwdUsed) {
                this.reqArgs.add("--keystorePassword");
            } else if (!this.pwdArgs.isEmpty() && !keyStorePwdUsed) {
                Trlog.debug(className, methodName, "keystorePassword or the remaining password arguments " + this.pwdArgs + " is missing.");
                this.printMissingPasswordArgs(this.pwdArgs);
            }
        }
        this.validateArgumentList(args, false);
        String serverName = this.getTaskTarget(args);
        String userDir = this.fileUtility.getUserDir();
        String serverDir = userDir + "servers" + "/" + serverName + "/";
        if (!this.fileUtility.exists(serverDir)) {
            userDir = this.fileUtility.resolvePath(userDir);
            this.abort(this.getMessage("serverNotFound", serverName, userDir), methodName);
        }
        this.collectiveResourcesDir = new File(serverDir + "resources/collective");
        if (this.fileUtility.exists(this.collectiveResourcesDir) && !this.fileUtility.isDirectoryEmpty(this.collectiveResourcesDir)) {
            this.abort(this.getMessage("create.errorAlreadyHasResources", new Object[0]), methodName);
        }
        if (this.isConfigFileInDropins(args, checkInDefaultsDir = true)) {
            this.abort(this.getMessage("create.configLocationInDefaults", new Object[0]), methodName);
        }
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String rootKSPassword = this.getArgumentValue("--rootKeystorePassword", args, keystorePassword);
        String serverIdentityKeystorePassword = this.getArgumentValue("--serverIdentityKeystorePassword", args, keystorePassword);
        String collectiveTrustKSPassword = this.getArgumentValue("--collectiveTrustKeystorePassword", args, keystorePassword);
        String httpsKSPassword = this.getArgumentValue("--httpsKeystorePassword", args, keystorePassword);
        String httpsTSPassword = this.getArgumentValue("--httpsTruststorePassword", args, keystorePassword);
        String hostName = this.getArgumentValue("--hostName", args, this.getHostName());
        List subjectAltNames = null;
        try {
            subjectAltNames = CollectiveDNUtil.buildSubjectAltNames((String)hostName);
        }
        catch (UnknownHostException e1) {
            this.abort("UnknownHostException for host: " + hostName, methodName);
        }
        catch (PrivilegedActionException e1) {
            this.abort("PrivilegedActionException", methodName);
        }
        if (predType.equals("SAF") || predType.equals("CUSTOMFILE")) {
            configXML = this.processBYO_SSLOptions(args, hostName, serverName, serverDir, predType, keystorePassword, serverIdentityKeystorePassword, collectiveTrustKSPassword);
        } else {
            String encodedKeystorePassword;
            int rootCertValidity;
            int serverIdentityCertificateValidity = Integer.valueOf(this.getArgumentValue("--serverIdentityCertificateValidity", args, String.valueOf(1825)));
            if (serverIdentityCertificateValidity < 365) {
                this.abort(this.getMessage("common.validityTooShort", "--serverIdentityCertificateValidity"), methodName);
            }
            if ((rootCertValidity = Integer.valueOf(this.getArgumentValue("--rootCertificateValidity", args, String.valueOf(9125))).intValue()) < 365) {
                this.abort(this.getMessage("common.validityTooShort", "--rootCertificateValidity"), methodName);
            }
            if (rootCertValidity < serverIdentityCertificateValidity) {
                this.abort(this.getMessage("common.rootCertValidityShorterThanServerValidity", rootCertValidity, serverIdentityCertificateValidity), methodName);
            }
            String defaultHTTPSCertificateSubject = "CN=" + hostName + ",OU=" + serverName + ",O=ibm,C=us";
            String httpsCertificateSubject = this.getArgumentValue("--httpsCertificateSubject", args, defaultHTTPSCertificateSubject);
            int httpsCertificateValidity = Integer.valueOf(this.getArgumentValue("--httpsCertificateValidity", args, String.valueOf(1825)));
            if (httpsCertificateValidity < 365) {
                this.abort(this.getMessage("common.validityTooShort", "--httpsCertificateValidity"), methodName);
            }
            try {
                new LdapName(httpsCertificateSubject);
            }
            catch (InvalidNameException e) {
                Trlog.debug(className, methodName, "Caught InvalidNameException while getting LdapName", e);
                this.abort(this.getMessage("common.invalidDN", "--httpsCertificateSubject", httpsCertificateSubject), methodName);
            }
            String collectiveName = this.getArgumentValue("--collectiveName", args, null);
            String encoding = this.getArgumentValue("--encoding", args, "xor");
            String aesConfigFile = this.getArgumentValue("--aesConfigFile", args, null);
            String key = this.getArgumentValue("--key", args, null);
            String base64Key = this.getArgumentValue("--base64Key", args, null);
            EncodingProperty prop = this.validateEncoding(encoding, key, aesConfigFile, base64Key);
            if (keystorePassword != null && (encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", prop)) == null) {
                this.abort("Encoded keystore password is null", methodName);
            }
            String encodedRootKSPassword = this.encodePassword(rootKSPassword, "--rootKeystorePassword", prop);
            String encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", prop);
            String encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--serverIdentityKeystorePassword", prop);
            String encodedHTTPSKSPassword = this.encodePassword(httpsKSPassword, "--httpsKeystorePassword", prop);
            String encodedHTTPSTSPassword = this.encodePassword(httpsTSPassword, "--httpsTruststorePassword", prop);
            if (encodedRootKSPassword == null || encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null || encodedHTTPSKSPassword == null || encodedHTTPSTSPassword == null) {
                this.abort(null, methodName);
            }
            File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
            File collectiveNameFile = new File(serverDir + "resources/collective/collective.name");
            File rootKeysFile = new File(serverDir + "resources/collective/rootKeys.p12");
            File serverIdentityKeyFile = new File(serverDir + "resources/collective/serverIdentity.p12");
            File collectiveTrustKeyFile = new File(serverDir + "resources/collective/collectiveTrust.p12");
            if (!this.fileUtility.createParentDirectory(stdout, collectiveUUIDFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, collectiveNameFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, rootKeysFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, serverIdentityKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, collectiveTrustKeyFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            File httpsKSFile = new File(serverDir + "resources/security/key.p12");
            File tmpHttpsKSFile = new File(serverDir + "resources/security/key.p12" + ".tmp");
            if (httpsKSFile.exists()) {
                Trlog.debug(className, methodName, "Regenerates the certificate as the default HTTPS keystore file exists at " + httpsKSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateKey", httpsKSFile.getAbsolutePath()));
            }
            File httpsTSFile = new File(serverDir + "resources/security/trust.p12");
            File tmpHttpsTSFile = new File(serverDir + "resources/security/trust.p12" + ".tmp");
            if (httpsTSFile.exists()) {
                Trlog.debug(className, methodName, "Regenerates the certificate as the default HTTPS truststore file exists at " + httpsTSFile.getAbsolutePath());
                stdout.println(this.getMessage("common.regenerateTrust", httpsTSFile.getAbsolutePath()));
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsKSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, httpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.fileUtility.createParentDirectory(stdout, tmpHttpsTSFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            Trlog.debug(className, methodName, "Creating required certificates to establish a collective ...");
            stdout.println(this.getMessage("create.start", new Object[0]));
            KeyStore rootKS = this.certUtil().createKeystore(rootKeysFile, rootKSPassword.toCharArray());
            KeyStore serverIdentityKS = this.certUtil().createKeystore(serverIdentityKeyFile, serverIdentityKeystorePassword.toCharArray());
            KeyStore collectiveTrustKS = this.certUtil().createKeystore(collectiveTrustKeyFile, serverIdentityKeystorePassword.toCharArray());
            KeyStore httpsKS = this.certUtil().createKeystore(tmpHttpsKSFile, httpsKSPassword.toCharArray());
            KeyStore httpsTS = this.certUtil().createKeystore(tmpHttpsTSFile, httpsTSPassword.toCharArray());
            String uuid = UUID.randomUUID().toString();
            if (!this.fileUtility.writeToFile(stderr, uuid, collectiveUUIDFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (collectiveName != null && !this.fileUtility.writeToFile(stderr, collectiveName, collectiveNameFile)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            this.processBYO_SSH_KeyPairOptions(args, uuid, serverDir, null, null);
            String dn = CollectiveDNUtil.buildControllerRootCertificateDN((String)uuid);
            PkSsCertificate controllerRootKey = this.certUtil().createSelfSignedCACert(dn, subjectAltNames, rootCertValidity);
            if (controllerRootKey == null) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            } else {
                Trlog.debug(className, methodName, "Generated controller root certificate: " + dn);
                stdout.println(this.getMessage("create.genCertControllerRoot", new Object[0]));
            }
            dn = CollectiveDNUtil.buildMemberRootCertificateDN((String)uuid);
            PkSsCertificate memberRootKey = this.certUtil().createSelfSignedCACert(dn, subjectAltNames, rootCertValidity);
            if (memberRootKey == null) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            } else {
                Trlog.debug(className, methodName, "Generated member root certificate: " + dn);
                stdout.println(this.getMessage("create.genCertMemberRoot", new Object[0]));
            }
            dn = CollectiveDNUtil.buildControllerDN((String)serverName, (String)userDir, (String)hostName, (String)uuid);
            PkNewCertificate serverIdentityKey = this.certUtil().createSignedCert(dn, subjectAltNames, serverIdentityCertificateValidity, controllerRootKey);
            if (serverIdentityKey == null) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            } else {
                Trlog.debug(className, methodName, "Generated server identity certificate: " + dn);
                stdout.println(this.getMessage("create.genCertServerIdentity", dn));
            }
            PkNewCertificate httpsKey = this.certUtil().createSignedCert(httpsCertificateSubject, subjectAltNames, httpsCertificateValidity, controllerRootKey);
            if (httpsKey == null) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            } else {
                Trlog.debug(className, methodName, "Generated HTTPS certificate: " + httpsCertificateSubject);
                stdout.println(this.getMessage("create.genCertHTTPS", new Object[0]));
            }
            if (!this.certUtil().setToKeyStore(controllerRootKey, rootKS, rootKSPassword, "controllerRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setToKeyStore(memberRootKey, rootKS, rootKSPassword, "memberRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setToKeyStore(serverIdentityKey, serverIdentityKS, serverIdentityKeystorePassword, "serverIdentity")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setToKeyStore(httpsKey, httpsKS, httpsKSPassword, "default")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setCertToKeyStore(controllerRootKey.getCertificate(), collectiveTrustKS, "controllerRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setCertToKeyStore(memberRootKey.getCertificate(), collectiveTrustKS, "memberRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setCertToKeyStore(controllerRootKey.getCertificate(), httpsTS, "controllerRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().setCertToKeyStore(memberRootKey.getCertificate(), httpsTS, "memberRoot")) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().saveKeyStore(rootKS, rootKeysFile, rootKSPassword)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().saveKeyStore(serverIdentityKS, serverIdentityKeyFile, serverIdentityKeystorePassword)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().saveKeyStore(collectiveTrustKS, collectiveTrustKeyFile, serverIdentityKeystorePassword)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().saveKeyStore(httpsKS, tmpHttpsKSFile, httpsKSPassword)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            if (!this.certUtil().saveKeyStore(httpsTS, tmpHttpsTSFile, httpsTSPassword)) {
                this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
            }
            this.updateExistingSSLKeys(httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, this.collectiveResourcesDir);
            configXML = this.getConfigXML(args, hostName, prop, encodedRootKSPassword, encodedServerIdentityKeystorePassword, encodedCollectiveTrustKSPassword, encodedHTTPSKSPassword, encodedHTTPSTSPassword);
        }
        stdout.println();
        stdout.println(this.getMessage("create.successful", serverName));
        this.handleConfigXML(stdout, args, serverDir, configXML);
        stdout.println(this.getMessage("create.configureSecurity", new Object[0]));
        Trlog.exit(className, methodName, "collective is created successfully.");
    }

    private String getConfigXML(String[] args, String hostName, EncodingProperty prop, String encodedRootKSPassword, String encodedServerIdentityKeystorePassword, String encodedCollectiveTrustKSPassword, String encodedHTTPSKSPassword, String encodedHTTPSTSPassword) {
        String xmlSnippet = "    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertCollectiveHostAuthConfig(args, null, null) + NL + "    <!-- TODO: Set the security configuration for Administrative access -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(prop) + "    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\"" + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore -->" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedHTTPSKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/key.p12" + "\" />" + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" password=\"" + encodedHTTPSTSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/security/trust.p12" + "\" />" + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" password=\"" + encodedServerIdentityKeystorePassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/serverIdentity.p12" + "\" />" + NL + NL + "    <!-- collective trust keystore -->" + NL + "    <keyStore id=\"collectiveTrust\" password=\"" + encodedCollectiveTrustKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/collectiveTrust.p12" + "\" />" + NL + NL + "    <!-- collective root signers keystore -->" + NL + "    <keyStore id=\"collectiveRootKeys\" password=\"" + encodedRootKSPassword + "\"" + NL + "              location=\"${server.config.dir}/" + "resources/collective/rootKeys.p12" + "\" />" + NL;
        return xmlSnippet;
    }

    private String getCustomConfigXML(String[] args, String hostName, EncodingProperty prop, String safKeyRing, String safCertificateLabel, String safCertificateRdn, String serverIdentityKS, String serverIdentityAlias, String encodedServerIdentityKeystorePassword, String collectiveTrustKS, String encodedCollectiveTrustKSPassword) {
        StringBuffer SSLkeyStoreInfoXML = new StringBuffer();
        SSLkeyStoreInfoXML.append("    <featureManager>" + NL + "        <feature>collectiveController-1.0</feature>" + NL + "    </featureManager>" + NL + NL + this.insertHostNameVariable(hostName) + NL + this.insertCollectiveHostAuthConfig(args, safKeyRing, safCertificateLabel) + NL + "    <!-- TODO: Set the security configuration for Administrative access -->" + NL + "    <quickStartSecurity userName=\"\" userPassword=\"\" />" + NL + NL + this.insertEncodingKey(prop) + NL + NL + this.insertCustomSSLConfigs(args, safCertificateRdn, serverIdentityKS, serverIdentityAlias, encodedServerIdentityKeystorePassword, collectiveTrustKS, encodedCollectiveTrustKSPassword));
        return SSLkeyStoreInfoXML.toString();
    }

    protected String insertCollectiveHostAuthConfig(String[] args, String safKeyRingDefault, String safCertificateLabelDefault) {
        String sshPublicKeyPath = this.getArgumentValue("--sshPublicKey", args, null);
        String sshPrivateKeyPath = this.getArgumentValue("--sshPrivateKey", args, null);
        String sshPrivateKeyPassword = this.getArgumentValue("--sshPrivateKeyPassword", args, null);
        String safKeyRing = this.getArgumentValue("--safKeyring", args, safKeyRingDefault);
        String safCertificateLabel = this.getArgumentValue("--safCertificateLabel", args, safCertificateLabelDefault);
        String safKeystoreType = this.getArgumentValue("--safKeystoreType", args, null);
        String safKeystoreProvider = this.getArgumentValue("--safKeystoreProvider", args, null);
        String safKeystoreKeyRecoverPassword = null;
        StringBuffer collectiveHostAuthInfoXML = new StringBuffer();
        if (safKeyRing == null && sshPublicKeyPath == null) {
            return collectiveHostAuthInfoXML.toString();
        }
        collectiveHostAuthInfoXML.append("    <!-- BYO collective-wide SSH Key information. -->" + NL);
        collectiveHostAuthInfoXML.append("    <collectiveHostAuthInfo " + NL);
        if (safKeyRing != null) {
            collectiveHostAuthInfoXML.append("         safKeyring=\"" + safKeyRing + "\"" + NL);
            collectiveHostAuthInfoXML.append("         safCertificateLabel=\"" + safCertificateLabel + "\"" + NL);
            if (safKeystoreKeyRecoverPassword != null) {
                collectiveHostAuthInfoXML.append("         safKeystoreKeyRecoverPassword=\"" + safKeystoreKeyRecoverPassword + "\"" + NL);
            }
            if (safKeystoreType != null) {
                collectiveHostAuthInfoXML.append("         safKeystoreType=\"" + safKeystoreType + "\"" + NL);
            }
            if (safKeystoreProvider != null) {
                collectiveHostAuthInfoXML.append("         safKeystoreProvider=\"" + safKeystoreProvider + "\"" + NL);
            }
        }
        if (sshPublicKeyPath != null) {
            collectiveHostAuthInfoXML.append("         sshPublicKeyPath=\"" + sshPublicKeyPath + "\"" + NL);
            collectiveHostAuthInfoXML.append("         sshPrivateKeyPath=\"" + sshPrivateKeyPath + "\"" + NL);
            if (sshPrivateKeyPassword != null) {
                collectiveHostAuthInfoXML.append("         sshPrivateKeyPassword=\"" + sshPrivateKeyPassword + "\"" + NL);
            }
        }
        int lastNewline = collectiveHostAuthInfoXML.lastIndexOf(NL);
        collectiveHostAuthInfoXML.replace(lastNewline, collectiveHostAuthInfoXML.length(), " />" + NL);
        return collectiveHostAuthInfoXML.toString();
    }

    protected void processBYO_SSH_KeyPairOptions(String[] args, String uuid, String serverDir, String safKeyRingDefault, String safCertificateLabelDefault) throws TaskErrorException {
        String sshPublicKeyPath = this.getArgumentValue("--sshPublicKey", args, null);
        String sshPrivateKeyPath = this.getArgumentValue("--sshPrivateKey", args, null);
        String sshPrivateKeyPassword = this.getArgumentValue("--sshPrivateKeyPassword", args, null);
        String safKeyRing = this.getArgumentValue("--safKeyring", args, safKeyRingDefault);
        String safCertificateLabel = this.getArgumentValue("--safCertificateLabel", args, safCertificateLabelDefault);
        String safKeystoreType = this.getArgumentValue("--safKeystoreType", args, "JCERACFKS");
        String safKeystoreProvider = this.getArgumentValue("--safKeystoreProvider", args, null);
        String safKS_KeyRecoverPassword = null;
        if (sshPublicKeyPath != null && sshPrivateKeyPath == null) {
            this.abortAndPerformCleanup(this.getMessage("create.sshPublicKeyWithoutPrivate", new Object[0]), this.collectiveResourcesDir);
        }
        if (sshPublicKeyPath == null && sshPrivateKeyPath != null) {
            this.abortAndPerformCleanup(this.getMessage("create.sshPrivateKeyWithoutPublic", new Object[0]), this.collectiveResourcesDir);
        }
        if (sshPrivateKeyPassword != null && sshPublicKeyPath == null) {
            this.abortAndPerformCleanup(this.getMessage("create.sshPrivateKeyPasswordWithoutSSHKeys", new Object[0]), this.collectiveResourcesDir);
        }
        if (safKeyRing != null && safCertificateLabel == null) {
            this.abortAndPerformCleanup(this.getMessage("create.safKeyringWithoutLabel", new Object[0]), this.collectiveResourcesDir);
        }
        if (safKeyRing == null && safCertificateLabel != null) {
            this.abortAndPerformCleanup(this.getMessage("create.safLabelWithoutKeyring", new Object[0]), this.collectiveResourcesDir);
        }
        if (sshPublicKeyPath != null && safKeyRing != null) {
            this.abortAndPerformCleanup(this.getMessage("create.sshKeyAndSafKeyring", new Object[0]), this.collectiveResourcesDir);
        }
        if (safKeyRing != null) {
            this.verifySAFSSHKeys(safKeyRing, safCertificateLabel, safKeystoreType, safKeystoreProvider, safKS_KeyRecoverPassword, true, this.collectiveResourcesDir);
        }
        if (sshPublicKeyPath != null) {
            this.verifyFileSSHKeys(this.sshKeyUtil, sshPublicKeyPath, sshPrivateKeyPath, sshPrivateKeyPassword, true, this.collectiveResourcesDir);
        }
        if (safKeyRing == null && sshPublicKeyPath == null) {
            String currentUserHome = System.getProperty("user.home");
            String collectiveName = this.getArgumentValue("--collectiveName", args, "defaultCollective");
            this.getCollectiveSSHKey(this.sshKeyUtil, currentUserHome, collectiveName + " (uuid " + uuid + ")", serverDir);
        }
    }

    protected String processBYO_SSLOptions(String[] args, String hostName, String serverName, String serverDir, String predType, String keystorePassword, String serverIdentityKeystorePassword, String collectiveTrustKSPassword) throws TaskErrorException {
        String uuid;
        String safCertificateRdn;
        String methodName = "processBYO_SSLOptions";
        List<String> list = Arrays.asList(args);
        Boolean setupSAF = list.contains("--setupSAF");
        String serverIdentitycustomKS = this.getArgumentValue("--serverIdentityKeystore", args, null);
        String serverIdentityAlias = this.getArgumentValue("--serverIdentityKeystoreAlias", args, null);
        String collectiveTrustcustomKS = this.getArgumentValue("--collectiveTrustKeystore", args, null);
        String safDefaultRDN = null;
        String safKeyRing = this.getArgumentValue("--safKeyring", args, null);
        String safCertificateLabel = this.getArgumentValue("--safCertificateLabel", args, null);
        String collectiveName = this.getArgumentValue("--collectiveName", args, null);
        if (setupSAF.booleanValue()) {
            String SSLKeystoreName;
            String prefix = "LZController";
            safKeyRing = "safkeyring:///" + prefix + ".SSHRing";
            safCertificateLabel = prefix + ".SSH";
            serverIdentitycustomKS = SSLKeystoreName = "safkeyring:///" + prefix + ".Ring";
            collectiveTrustcustomKS = SSLKeystoreName;
            serverIdentityAlias = prefix + ".CERT";
            safDefaultRDN = "OU=LZCollective";
        }
        if ((safCertificateRdn = this.getArgumentValue("--certificateRdn", args, safDefaultRDN)) != null) {
            try {
                new Rdn(safCertificateRdn);
            }
            catch (InvalidNameException e) {
                Trlog.debug(className, methodName, "Caught InvalidNameException while getting Rdn", e);
                this.abortAndPerformCleanup(this.getMessage("common.invalidDN", "--certificateRdn", safCertificateRdn), this.collectiveResourcesDir, methodName);
            }
        }
        File collectiveUUIDFile = new File(serverDir + "resources/collective/collective.uuid");
        File collectiveNameFile = new File(serverDir + "resources/collective/collective.name");
        if (!this.fileUtility.createParentDirectory(this.stdout, collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
        }
        if (!this.fileUtility.createParentDirectory(this.stdout, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
        }
        if (!this.fileUtility.writeToFile(this.stderr, uuid = UUID.randomUUID().toString(), collectiveUUIDFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
        }
        if (collectiveName != null && !this.fileUtility.writeToFile(this.stderr, collectiveName, collectiveNameFile)) {
            this.abortAndPerformCleanup(null, this.collectiveResourcesDir, methodName);
        }
        this.processBYO_SSH_KeyPairOptions(args, uuid, serverDir, safKeyRing, safCertificateLabel);
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String aesConfigFile = this.getArgumentValue("--aesConfigFile", args, null);
        String key = this.getArgumentValue("--key", args, null);
        String base64Key = this.getArgumentValue("--base64Key", args, null);
        EncodingProperty prop = this.validateEncoding(encoding, key, aesConfigFile, base64Key);
        String encodedServerIdentityKeystorePassword = null;
        String encodedCollectiveTrustKSPassword = null;
        if (predType.equals("CUSTOMFILE")) {
            encodedServerIdentityKeystorePassword = this.encodePassword(serverIdentityKeystorePassword, "--serverIdentityKeystorePassword", prop);
            encodedCollectiveTrustKSPassword = this.encodePassword(collectiveTrustKSPassword, "--serverIdentityKeystorePassword", prop);
            if (encodedServerIdentityKeystorePassword == null || encodedCollectiveTrustKSPassword == null) {
                this.abort(null, methodName);
            }
            this.verifyFileSSL(serverIdentitycustomKS, collectiveTrustcustomKS, serverIdentityAlias, serverIdentityKeystorePassword, collectiveTrustKSPassword, true, this.collectiveResourcesDir);
        } else {
            String safKeystoreType = this.getArgumentValue("--safKeystoreType", args, "JCERACFKS");
            String safKeystoreProvider = this.getArgumentValue("--safKeystoreProvider", args, null);
            this.verifySAFSSL(Arrays.asList(serverIdentitycustomKS, collectiveTrustcustomKS), serverIdentityAlias, safKeystoreType, safKeystoreProvider, true, this.collectiveResourcesDir);
        }
        return this.getCustomConfigXML(args, hostName, prop, safKeyRing, safCertificateLabel, safCertificateRdn, serverIdentitycustomKS, serverIdentityAlias, encodedServerIdentityKeystorePassword, collectiveTrustcustomKS, encodedCollectiveTrustKSPassword);
    }

    @Override
    protected List<String> getBetaOptions() {
        return BETA_OPTS;
    }
}

