/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeUtil;
import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XList;
import com.ibm.xml.xlxp2.datatype.validation.QNameDV;
import com.ibm.xml.xlxp2.datatype.validation.UnionDV;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;
import java.util.StringTokenizer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ListDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private XList[] enumeration;
    private int[][] enumerationType;
    private final TypeValidator itemTypeValidator;

    public ListDV(String string, String string2, String string3, String[] stringArray, int n, int n2, int n3, int n4, int n5, TypeValidator typeValidator) {
        super(string, string2, string3, n5, 45, stringArray, n4, false);
        this.itemTypeValidator = typeValidator;
        this.length = n;
        this.minLength = n2;
        this.maxLength = n3;
    }

    public void setEnumeration(ValidatedInfo[] validatedInfoArray) {
        this.createEnumeration(validatedInfoArray);
    }

    private void createEnumeration(ValidatedInfo[] validatedInfoArray) {
        if (validatedInfoArray != null) {
            this.enumeration = ArrayAllocator.newObjectArray(XList.class, validatedInfoArray.length);
            this.enumerationType = ArrayAllocator.newIntArray2(validatedInfoArray.length);
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (validatedInfoArray[i] == null) continue;
                this.enumeration[i] = (XList)validatedInfoArray[i].actualValue;
                this.enumerationType[i] = validatedInfoArray[i].itemBuiltinKinds;
            }
        }
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        throw new RuntimeException("Should never be called.");
    }

    public Object getActualValue(String string, int[] nArray, String[] stringArray, String string2, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
        }
        return ListDV.getActualValue(this.itemTypeValidator, string, nArray, stringArray, string2, validatedInfo, typeUtil);
    }

    public static Object getActualValue(TypeValidator typeValidator, String string, int[] nArray, String[] stringArray, String string2, ValidatedInfo validatedInfo, TypeUtil typeUtil) {
        if (validatedInfo != null) {
            validatedInfo.itemBuiltinKinds = nArray;
        }
        int n = typeValidator.builtInKind;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        Object[] objectArray = ArrayAllocator.newObjectArray(n2);
        XMLString xMLString = new XMLString();
        for (int i = 0; i < n2; ++i) {
            String string3 = stringTokenizer.nextToken();
            if (n == 19 || n == 20) {
                objectArray[i] = ((QNameDV)typeValidator).getActualValue(string3, stringArray, string2, null);
                continue;
            }
            if (n == 45) {
                objectArray[i] = ((UnionDV)typeValidator).getActualValue(string3, nArray[i], null, stringArray, string2, null, typeUtil);
                continue;
            }
            typeUtil.addString(string3, xMLString);
            objectArray[i] = typeValidator.getActualValue(xMLString, null);
        }
        xMLString.unregister();
        validatedInfo.actualValue = new XList(objectArray);
        validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        return validatedInfo.actualValue;
    }

    public static ValidatedInfo parse(TypeValidator typeValidator, String string, int[] nArray, String[] stringArray, String string2, TypeUtil typeUtil) {
        ValidatedInfo validatedInfo = new ValidatedInfo();
        ListDV.getActualValue(typeValidator, string, nArray, stringArray, string2, validatedInfo, typeUtil);
        return validatedInfo;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XList xList = this.parseWithContext(xMLString, validationContext, validatedInfo2, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xList.isEqual((XList)validatedInfo.actualValue, validatedInfo.itemBuiltinKinds, validatedInfo2.itemBuiltinKinds) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xList, xMLString, validatedInfo2.itemBuiltinKinds);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xList;
    }

    private XList parseWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        if (xMLString.length == 0) {
            return new XList();
        }
        if (xMLString.bytes != null) {
            return this.parseListUnbufferedWithContext(xMLString, validationContext, validatedInfo, nArray);
        }
        return this.parseListBufferedWithContext(xMLString, validationContext, validatedInfo, nArray);
    }

    private XList parseListBufferedWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (n == n2) {
            nArray[0] = 1;
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        ValidatedInfo validatedInfo2 = new ValidatedInfo();
        block1: while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    while (true) {
                        if (n + 1 < n2) break;
                        if (dataBuffer == dataBuffer2) break block1;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n + 1];
                    if (by != 32 && by != 10 && by != 9 && by != 13) {
                        xMLString2.setStartPos(dataBuffer, n + 1);
                    }
                } else {
                    XMLString xMLString3;
                    while (true) {
                        if (n + 1 < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            xMLString2.setEndPos(dataBuffer, n + 1);
                            validatedInfo2.errorCode = 0;
                            this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                            if (validatedInfo2.errorCode == 1) {
                                nArray[0] = 1;
                                xMLString2.unregister();
                                return null;
                            }
                            if (xMLString2 == validatedInfo2.actualValue) {
                                xMLString3 = validationContext.getXMLString();
                                xMLString3.setValues(xMLString2);
                                validatedInfo2.actualValue = xMLString3;
                            }
                            arrayList.add(validatedInfo2.actualValue);
                            arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                            break block1;
                        }
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n + 1];
                    if (by == 32 || by == 10 || by == 9 || by == 13) {
                        xMLString2.setEndPos(dataBuffer, n + 1);
                        validatedInfo2.errorCode = 0;
                        this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                        if (validatedInfo2.errorCode == 1) {
                            nArray[0] = 1;
                            xMLString2.unregister();
                            return null;
                        }
                        if (xMLString2 == validatedInfo2.actualValue) {
                            xMLString3 = validationContext.getXMLString();
                            xMLString3.setValues(xMLString2);
                            validatedInfo2.actualValue = xMLString3;
                        }
                        arrayList.add(validatedInfo2.actualValue);
                        arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                    }
                }
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset - 1;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        xMLString2.unregister();
        validatedInfo.itemBuiltinKinds = ArrayAllocator.newIntArray(arrayList2.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            validatedInfo.itemBuiltinKinds[i] = (Integer)arrayList2.get(i);
        }
        return new XList(arrayList.toArray());
    }

    private XList parseListUnbufferedWithContext(XMLString xMLString, ValidationContext validationContext, ValidatedInfo validatedInfo, int[] nArray) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        ValidatedInfo validatedInfo2 = new ValidatedInfo();
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) == n2) {
            nArray[0] = 1;
            return null;
        }
        byte by = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        XMLString xMLString2 = validationContext.getXMLString();
        xMLString2.setValues(xMLString);
        xMLString2.startOffset = n;
        while (n < n2) {
            XMLString xMLString3;
            by = xMLString.bytes[n];
            if (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n + 1 < n2 && (by = xMLString.bytes[n + 1]) != 32 && by != 10 && by != 9 && by != 13) {
                    xMLString2.startOffset = n + 1;
                }
            } else if (n + 1 < n2) {
                by = xMLString.bytes[n + 1];
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    xMLString2.endOffset = n + 1;
                    xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                    xMLString2.hashcode = 0;
                    validatedInfo2.errorCode = 0;
                    this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                    if (validatedInfo2.errorCode == 1) {
                        nArray[0] = 1;
                        xMLString2.unregister();
                        return null;
                    }
                    if (xMLString2 == validatedInfo2.actualValue) {
                        xMLString3 = validationContext.getXMLString();
                        xMLString3.setValues(xMLString2);
                        validatedInfo2.actualValue = xMLString3;
                    }
                    arrayList.add(validatedInfo2.actualValue);
                    arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                }
            } else {
                xMLString2.endOffset = n + 1;
                xMLString2.length = xMLString2.endOffset - xMLString2.startOffset;
                xMLString2.hashcode = 0;
                validatedInfo2.errorCode = 0;
                this.itemTypeValidator.validate(xMLString2, null, validationContext, validatedInfo2);
                if (validatedInfo2.errorCode == 1) {
                    nArray[0] = 1;
                    xMLString2.unregister();
                    return null;
                }
                if (xMLString2 == validatedInfo2.actualValue) {
                    xMLString3 = validationContext.getXMLString();
                    xMLString3.setValues(xMLString2);
                    validatedInfo2.actualValue = xMLString3;
                }
                arrayList.add(validatedInfo2.actualValue);
                arrayList2.add(validatedInfo2.typeValidator.builtInKind);
                break;
            }
            ++n;
        }
        xMLString2.unregister();
        validatedInfo.itemBuiltinKinds = ArrayAllocator.newIntArray(arrayList2.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            validatedInfo.itemBuiltinKinds[i] = (Integer)arrayList2.get(i);
        }
        return new XList(arrayList.toArray());
    }

    private int checkFacets(XList xList, XMLString xMLString, int[] nArray) {
        if ((this.definedFacets & 2) != 0 && xList.length < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0 && xList.length > this.maxLength) {
            return 1;
        }
        if ((this.definedFacets & 1) != 0 && xList.length != this.length) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].isEqual(xList, nArray, this.enumerationType[i])) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public int checkIdrefAndEntity(Object object, ValidationContext validationContext) {
        if (object instanceof XList) {
            XList xList = (XList)object;
            for (int i = 0; i < xList.length; ++i) {
                if (this.itemTypeValidator.checkIdrefAndEntity(xList.value[i], validationContext) == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public TypeValidator getItemTypeValidator() {
        return this.itemTypeValidator;
    }
}

