/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype;

import com.ibm.xml.xlxp2.datatype.XInt;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XDecimal {
    private static final long[] longRanges;
    private static final int[] intRanges;
    public static final XDecimal ZERO;
    public int sign;
    public int totalDigits;
    public int intDigits;
    public int fracDigits;
    public XMLString rawData;

    public XDecimal() {
        this.sign = 0;
        this.totalDigits = 0;
        this.intDigits = 0;
        this.fracDigits = 0;
        this.rawData = null;
    }

    public XDecimal(DataBuffer dataBuffer, int n, DataBuffer dataBuffer2, int n2, int n3, int n4, int n5) {
        XMLString xMLString = new XMLString();
        if (dataBuffer == dataBuffer2) {
            xMLString.setValues(dataBuffer, n, n2);
        } else {
            xMLString.setStartPos(dataBuffer, n);
            xMLString.setEndPos(dataBuffer2, n2);
        }
        this.rawData = xMLString;
        this.intDigits = n3;
        this.fracDigits = n4;
        this.sign = n5;
        this.totalDigits = n3 + n4;
    }

    public void setValues(DataBuffer dataBuffer, int n, DataBuffer dataBuffer2, int n2, int n3, int n4, int n5) {
        if (this.rawData == null) {
            this.rawData = new XMLString();
        }
        if (dataBuffer == dataBuffer2) {
            this.rawData.setValues(dataBuffer, n, n2);
        } else {
            this.rawData.setValues(dataBuffer, dataBuffer2, n, n2);
        }
        this.intDigits = n3;
        this.fracDigits = n4;
        this.sign = n5;
        this.totalDigits = n3 + n4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XDecimal) {
            XDecimal xDecimal = (XDecimal)object;
            if (this.sign != xDecimal.sign) {
                return false;
            }
            if (this.sign == 0) {
                return true;
            }
            return this.intDigits == xDecimal.intDigits && this.fracDigits == xDecimal.fracDigits && this.rawData.equals(xDecimal.rawData);
        }
        if (object instanceof XInt) {
            return this.equals(((XInt)object).value);
        }
        if (object instanceof XLong) {
            return this.equals(((XLong)object).value);
        }
        return false;
    }

    public boolean equals(long l) {
        long l2;
        if (this.fracDigits > 0 || this.intDigits > 19) {
            return false;
        }
        if (this.sign == 0) {
            return l == 0L;
        }
        if (this.sign == 1 && l < 0L || this.sign == -1 && l > 0L) {
            return false;
        }
        long l3 = l2 = l > 0L ? -l : l;
        if (l2 < longRanges[this.intDigits] && l2 >= longRanges[this.intDigits + 1]) {
            return this.equals2(l);
        }
        return false;
    }

    private boolean equals2(long l) {
        boolean bl = this.sign == -1;
        long l2 = bl ? Long.MIN_VALUE : -9223372036854775807L;
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer == null ? dataBuffer : this.rawData.lastBuffer;
        int n = this.rawData.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n++];
        long l3 = 48 - by;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n++];
                int n3 = by - 48;
                if (l3 >= -922337203685477580L && (l3 *= 10L) >= l2 + (long)n3) {
                    l3 -= (long)n3;
                    continue;
                }
                return false;
            }
            if (dataBuffer == dataBuffer2) {
                return (bl ? l3 : -l3) == l;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        }
    }

    public boolean equals(int n) {
        int n2;
        if (this.fracDigits > 0 || this.intDigits > 10) {
            return false;
        }
        if (this.sign == 0) {
            return n == 0;
        }
        if (this.sign == 1 && n < 0 || this.sign == -1 && n > 0) {
            return false;
        }
        int n3 = n2 = n > 0 ? -n : n;
        if (n2 < intRanges[this.intDigits] && n2 >= intRanges[this.intDigits + 1]) {
            return this.equals2(n);
        }
        return false;
    }

    private boolean equals2(int n) {
        boolean bl = this.sign == -1;
        int n2 = bl ? Integer.MIN_VALUE : -2147483647;
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer == null ? dataBuffer : this.rawData.lastBuffer;
        int n3 = this.rawData.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n3++];
        int n5 = 48 - by;
        while (true) {
            if (n3 < n4) {
                by = dataBuffer.bytes[n3++];
                int n6 = by - 48;
                if (n5 >= -214748364 && (n5 *= 10) >= n2 + n6) {
                    n5 -= n6;
                    continue;
                }
                return false;
            }
            if (dataBuffer == dataBuffer2) {
                return (bl ? n5 : -n5) == n;
            }
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
            n4 = dataBuffer == dataBuffer2 ? this.rawData.endOffset : dataBuffer.endOffset;
        }
    }

    public int compareTo(XDecimal xDecimal) {
        if (this.sign != xDecimal.sign) {
            return this.sign > xDecimal.sign ? 1 : -1;
        }
        if (this.sign == 0) {
            return 0;
        }
        if (this.intDigits != xDecimal.intDigits) {
            return this.intDigits > xDecimal.intDigits ? this.sign : -this.sign;
        }
        int n = this.rawData.compare(xDecimal.rawData);
        if (n != 0) {
            return n > 0 ? this.sign : -this.sign;
        }
        return 0;
    }

    public int hashCode() {
        if (this.sign == 0) {
            return 0;
        }
        long l = 0L;
        if (this.rawData.bytes != null) {
            byte[] byArray = this.rawData.bytes;
            int n = this.rawData.startOffset;
            int n2 = this.rawData.endOffset;
            for (int i = n; i < n2; ++i) {
                l = l * 10L - (long)(byArray[i] - 48);
            }
            if (this.sign == 1) {
                l = -l;
            }
            return (int)(l ^ l >>> 32);
        }
        DataBuffer dataBuffer = this.rawData.firstBuffer;
        DataBuffer dataBuffer2 = this.rawData.lastBuffer != null ? this.rawData.lastBuffer : dataBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n = this.rawData.startOffset;
        int n3 = this.rawData.lastBuffer != null ? dataBuffer.endOffset : this.rawData.endOffset;
        while (true) {
            for (int i = n; i < n3; ++i) {
                l = l * 10L - (long)(byArray[i] - 48);
            }
            if (dataBuffer == dataBuffer2) {
                if (this.sign == 1) {
                    l = -l;
                }
                return (int)(l ^ l >>> 32);
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n = dataBuffer.startOffset;
            n3 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : this.rawData.endOffset;
        }
    }

    public String toString() {
        if (this.sign == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + this.rawData.length);
        if (this.sign == -1) {
            stringBuilder.append('-');
        }
        if (this.fracDigits == this.totalDigits) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.rawData.toString());
        return stringBuilder.toString();
    }

    static {
        int n;
        longRanges = new long[21];
        XDecimal.longRanges[0] = 0L;
        XDecimal.longRanges[1] = 0L;
        XDecimal.longRanges[2] = -9L;
        for (n = 3; n < 20; ++n) {
            XDecimal.longRanges[n] = longRanges[n - 1] * 10L - 9L;
        }
        XDecimal.longRanges[20] = Long.MIN_VALUE;
        intRanges = new int[12];
        XDecimal.intRanges[0] = 0;
        XDecimal.intRanges[1] = 0;
        XDecimal.intRanges[2] = -9;
        for (n = 3; n < 11; ++n) {
            XDecimal.intRanges[n] = intRanges[n - 1] * 10 - 9;
        }
        XDecimal.intRanges[11] = Integer.MIN_VALUE;
        ZERO = new XDecimal();
    }
}

