/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.wssec;

import com.ibm.xml.xlxp2.api.jaxb.JAXBXMLStreamReader;
import com.ibm.xml.xlxp2.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp2.api.util.ParsedEntityStream;
import com.ibm.xml.xlxp2.api.wssec.WSInfo;
import com.ibm.xml.xlxp2.api.wssec.XLXPWSInfoBuilder;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class WSSXMLStreamReader
extends JAXBXMLStreamReader {
    private static final boolean BUILD_WSINFO = false;
    private static final String WSINFO_CLASS_NAME = WSInfo.class.getName();
    private static final String PARSED_ENTITY_STREAM_CLASS_NAME = ParsedEntityStream.class.getName();
    private static final String SOAP_BODY_FIRST_CHILD_ELEMENT_QNAME = "org.apache.axiom.SOAPBodyFirstChildElementQName";
    private XLXPWSInfoBuilder fWSInfoBuilder = null;
    private boolean wsinfoChecked = false;
    private WSInfo wsinfo = null;
    private ParsedEntityStream parsedEntityStream = null;

    public WSSXMLStreamReader(InputSource inputSource, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        super(inputSource, stAXImplProperties);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        Object object = super.getProperty(string);
        if (object != null) {
            return object;
        }
        if (SOAP_BODY_FIRST_CHILD_ELEMENT_QNAME.equals(string)) {
            return this.getSOAPBodyFirstChildElementQName();
        }
        if (WSINFO_CLASS_NAME.equals(string)) {
            return this.getWSInfo();
        }
        if (PARSED_ENTITY_STREAM_CLASS_NAME.equals(string)) {
            return this.getParsedEntityStream();
        }
        return null;
    }

    public WSInfo getWSInfo() {
        if (!this.wsinfoChecked) {
            // empty if block
        }
        return this.wsinfo;
    }

    public ParsedEntityStream getParsedEntityStream() {
        if (this.fEventType == 1) {
            if (this.parsedEntityStream == null) {
                this.parsedEntityStream = new ParsedEntityStream();
            }
            this.parsedEntityStream.close();
            XMLString xMLString = this.parsedEntityStream.skippedContent();
            if (this.fIsLeafElement) {
                NullDataBufferFactory.setEmptyStringValues(xMLString);
                return this.parsedEntityStream;
            }
            if (this.skipContent(xMLString)) {
                return this.parsedEntityStream;
            }
        }
        return null;
    }

    public QName getSOAPBodyFirstChildElementQName() {
        WSInfo wSInfo = this.getWSInfo();
        return wSInfo != null ? wSInfo.getFirstSOAPBodyChild() : null;
    }

    public void close() throws XMLStreamException {
        this.wsinfoChecked = false;
        this.wsinfo = null;
        super.close();
    }
}

