/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LocalSingletonElector
implements Elector {
    private static final TraceComponent tc = Tr.register(LocalSingletonElector.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private SingletonServiceExtender service;
    private ServiceEndpointIdentity leader;
    private boolean electionStarted = false;
    private final Set<ServiceEndpointIdentity> candidateIdentities = new HashSet<ServiceEndpointIdentity>();
    static final long serialVersionUID = 3489238062048986709L;

    public void setSingletonService(SingletonServiceExtender service) {
        this.service = service;
    }

    public void start() {
    }

    public void stop() {
    }

    public void participantRegistered(ServiceEndpointIdentity participant) {
    }

    public void participantUnregistered(ServiceEndpointIdentity participant) {
    }

    public void candidateRegistered(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.add(candidate);
        Tr.info((TraceComponent)tc, (String)"CANDIDATE_REGISTERED", (Object[])new Object[]{candidate});
        if (!this.electionStarted) {
            this.electionStarted = true;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -8528399636811247144L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    new Thread(new ElectionRunner()).start();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.LocalSingletonElector$1", 1.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
                }
            });
        }
    }

    public void candidateUnregistered(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.remove(candidate);
        Tr.info((TraceComponent)tc, (String)"CANDIDATE_UNREGISTERED", (Object[])new Object[]{candidate});
    }

    public Set<ServiceEndpointIdentity> getParticipants() {
        return null;
    }

    public Set<ServiceEndpointIdentity> getCandidates() {
        return null;
    }

    public ServiceEndpointIdentity getLeader() {
        return null;
    }

    public String getIdentity() {
        return ManagementFactory.getRuntimeMXBean().getName() + ":0";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ElectionRunner
    implements Runnable {
        static final long serialVersionUID = -6690082741623914722L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ElectionRunner() {
        }

        private ServiceEndpointIdentity elect() {
            int numCandidates;
            Object[] candidates = LocalSingletonElector.this.candidateIdentities.toArray();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Election runner SingletonService reference: " + LocalSingletonElector.this.service), (Object[])new Object[0]);
            }
            if ((numCandidates = candidates.length) == 0) {
                throw new IllegalStateException("There are no registered candidates for service " + LocalSingletonElector.this.service.getName());
            }
            Random random = new Random();
            ServiceEndpointIdentity leader = (ServiceEndpointIdentity)candidates[random.nextInt(numCandidates)];
            return leader;
        }

        @Override
        public void run() {
            LocalSingletonElector.this.leader = this.elect();
            LocalSingletonElector.this.service.leaderElected(LocalSingletonElector.this.leader);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Leader is elected.", (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.LocalSingletonElector$ElectionRunner", ElectionRunner.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
        }
    }
}

