/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedDirectory;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar;
import com.ibm.ws.annocache.classsource.specification.ClassSource_Specification_Direct_WAR;
import com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification_Direct;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_Specification_Direct_WAR
extends ClassSourceImpl_Specification_Direct
implements ClassSource_Specification_Direct_WAR {
    public static final String CLASS_NAME;
    protected boolean ignoreClassesPath = false;
    protected String classesPath = null;
    protected boolean ignoreLibPath = false;
    protected String libPath = null;
    protected List<String> libPaths = null;
    private Set<String> partialPaths;
    private Set<String> excludedPaths;
    static final long serialVersionUID = 8667508528428278302L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_Specification_Direct_WAR(ClassSourceImpl_Factory factory, String appName, String modName, String modCatName) {
        super(factory, appName, modName, modCatName);
    }

    @Override
    @Trivial
    public boolean getIgnoreClassesPath() {
        return this.ignoreClassesPath;
    }

    @Override
    public void setIgnoreClassesPath(boolean ignoreClassesPath) {
        this.ignoreClassesPath = ignoreClassesPath;
    }

    @Override
    @Trivial
    public String getDefaultClassesPath() {
        return "WEB-INF/classes/";
    }

    @Override
    @Trivial
    public String getClassesPath() {
        return this.classesPath;
    }

    @Override
    public void setClassesPath(String classesPath) {
        this.classesPath = classesPath;
    }

    @Override
    @Trivial
    public boolean getIgnoreLibPath() {
        return this.ignoreLibPath;
    }

    @Override
    public void setIgnoreLibPath(boolean ignoreLibPath) {
        this.ignoreLibPath = ignoreLibPath;
    }

    @Override
    @Trivial
    public String getDefaultLibPath() {
        return "WEB-INF/lib/";
    }

    @Override
    @Trivial
    public String getLibPath() {
        return this.libPath;
    }

    @Override
    public void setLibPath(String libPath) {
        this.libPath = libPath;
    }

    @Override
    @Trivial
    public List<String> getLibPaths() {
        return this.libPaths;
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(libPath, false, false);
    }

    @Override
    public void addLibPath(String libPath, boolean isPartial, boolean isExcluded) {
        if (this.libPaths == null) {
            this.libPaths = new ArrayList<String>();
        }
        this.libPaths.add(libPath);
        if (isPartial) {
            this.addPartialPath(libPath);
        } else if (isExcluded) {
            this.addExcludedPath(libPath);
        }
    }

    @Override
    public void addLibPaths(List<String> libPaths) {
        this.addLibPaths(libPaths, false, false);
    }

    @Override
    public void addLibPaths(List<String> libPaths, boolean isPartial, boolean isExcluded) {
        if (this.libPaths == null) {
            this.libPaths = new ArrayList<String>();
        }
        this.libPaths.addAll(libPaths);
        if (isPartial) {
            this.addPartialPaths(libPaths);
        } else if (isExcluded) {
            this.addExcludedPaths(libPaths);
        }
    }

    @Override
    @Trivial
    public boolean isPartialPath(String libPath) {
        return this.partialPaths != null && this.partialPaths.contains(libPath);
    }

    @Override
    public void addPartialPath(String libPath) {
        if (this.partialPaths == null) {
            this.partialPaths = new HashSet<String>();
        }
        this.partialPaths.add(libPath);
    }

    @Override
    public void addPartialPaths(Collection<String> libPath) {
        if (this.partialPaths == null) {
            this.partialPaths = new HashSet<String>();
        }
        this.partialPaths.addAll(this.libPaths);
    }

    @Override
    @Trivial
    public boolean isExcludedPath(String libPath) {
        return this.excludedPaths != null && this.excludedPaths.contains(libPath);
    }

    @Override
    public void addExcludedPath(String libPath) {
        if (this.excludedPaths == null) {
            this.excludedPaths = new HashSet<String>();
        }
        this.excludedPaths.add(libPath);
    }

    @Override
    public void addExcludedPaths(Collection<String> libPath) {
        if (this.excludedPaths == null) {
            this.excludedPaths = new HashSet<String>();
        }
        this.excludedPaths.addAll(this.libPaths);
    }

    @Trivial
    public ClassSource_Aggregate.ScanPolicy selectPolicy(String libPath) {
        if (this.isPartialPath(libPath)) {
            return ClassSource_Aggregate.ScanPolicy.PARTIAL;
        }
        if (this.isExcludedPath(libPath)) {
            return ClassSource_Aggregate.ScanPolicy.EXCLUDED;
        }
        return ClassSource_Aggregate.ScanPolicy.SEED;
    }

    @Override
    public void addInternalClassSources(ClassSource_Aggregate rootClassSource) throws ClassSource_Exception {
        if (!this.getIgnoreClassesPath()) {
            ClassSourceImpl_MappedDirectory classSourceImpl_MappedDirectory;
            String useClassesPath = this.getClassesPath();
            if (useClassesPath == null) {
                useClassesPath = this.getDefaultClassesPath();
                classSourceImpl_MappedDirectory = this.addDirectoryClassSource(rootClassSource, "WEB-INF/classes", this.getModulePath(), this.getDefaultClassesPath(), ClassSource_Aggregate.ScanPolicy.SEED);
            } else {
                classSourceImpl_MappedDirectory = this.addDirectoryClassSource(rootClassSource, "WEB-INF/classes", useClassesPath, ClassSource_Aggregate.ScanPolicy.SEED);
            }
        }
        if (!this.getIgnoreLibPath()) {
            List<String> useLibPaths = this.getLibPaths();
            String useModulePath = this.getModulePath();
            if (useLibPaths == null) {
                String useLibPath = this.getLibPath();
                if (useLibPath == null) {
                    useLibPath = useModulePath + this.getDefaultLibPath();
                }
                useLibPaths = new ArrayList<String>();
                this.selectJars(useLibPath, useLibPaths);
            }
            for (String nextLibPath : useLibPaths) {
                String nextLibName = nextLibPath.startsWith(useModulePath) ? nextLibPath.substring(useModulePath.length()) : nextLibPath;
                ClassSource_Aggregate.ScanPolicy scanPolicy = this.selectPolicy(nextLibPath);
                ClassSourceImpl_MappedJar classSourceImpl_MappedJar = this.addJarClassSource(rootClassSource, nextLibName, nextLibPath, scanPolicy);
            }
        }
    }

    @Override
    @Trivial
    public void logInternal(Logger useLogger) {
        super.logInternal(useLogger);
        String methodName = "logInternal";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Classes path [ " + this.getClassesPath() + " ]");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "    Library path [ " + this.getLibPath() + " ]");
        List<String> useLibPaths = this.getLibPaths();
        if (useLibPaths != null) {
            for (String nextLibPath : useLibPaths) {
                ClassSource_Aggregate.ScanPolicy nextScanPolicy = this.selectPolicy(nextLibPath);
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "      Library [ " + nextLibPath + " ] [ " + (Object)((Object)nextScanPolicy) + " ]");
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification_Direct_WAR", ClassSourceImpl_Specification_Direct_WAR.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_Specification_Direct_WAR.class.getSimpleName();
    }
}

