/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import java.io.IOException;
import java.util.Enumeration;

public final class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFLIATION_CHANGED = "affliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private boolean[] bitString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.ReasonFlags";

    private boolean isSet(int position) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSet", new Integer(position));
            debug.exit(8192L, (Object)className, "isSet", this.bitString[position]);
        }
        return this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (debug != null) {
            debug.entry(8192L, className, "set", new Integer(position), new Boolean(val));
        }
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
        if (debug != null) {
            debug.exit(8192L, className, "set");
        }
    }

    public ReasonFlags(byte[] reasons) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", (Object)reasons);
        }
        this.bitString = new BitArray(reasons.length * 8, reasons).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(boolean[] reasons) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", (Object)reasons);
            debug.exit(16384L, className, "ReasonFlags");
        }
        this.bitString = reasons;
    }

    public ReasonFlags(BitArray reasons) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", reasons);
        }
        this.bitString = reasons.toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", in);
        }
        DerValue derVal = in.getDerValue();
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", derVal);
        }
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public boolean[] getFlags() {
        if (debug != null) {
            debug.entry(16384L, className, "getFlags");
        }
        if (debug != null) {
            debug.exit(16384L, className, "getFlags");
        }
        return this.bitString;
    }

    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Boolean)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Boolean.");
            }
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        if (name.equalsIgnoreCase(UNUSED)) {
            this.set(0, val);
        } else if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, val);
        } else if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, val);
        } else if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, val);
        } else if (name.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, val);
        } else if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, val);
        } else if (name.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, val);
        } else if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, val);
        } else if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, val);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Name not recognized by ReasonFlags");
            }
            throw new IOException("Name not recognized by ReasonFlags");
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(UNUSED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Boolean(this.isSet(0)));
            }
            return new Boolean(this.isSet(0));
        }
        if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Boolean(this.isSet(1)));
            }
            return new Boolean(this.isSet(1));
        }
        if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", new Boolean(this.isSet(2)));
            }
            return new Boolean(this.isSet(2));
        }
        if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", new Boolean(this.isSet(3)));
            }
            return new Boolean(this.isSet(3));
        }
        if (name.equalsIgnoreCase(SUPERSEDED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_5", new Boolean(this.isSet(4)));
            }
            return new Boolean(this.isSet(4));
        }
        if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", new Boolean(this.isSet(5)));
            }
            return new Boolean(this.isSet(5));
        }
        if (name.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_7", new Boolean(this.isSet(6)));
            }
            return new Boolean(this.isSet(6));
        }
        if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_8", new Boolean(this.isSet(7)));
            }
            return new Boolean(this.isSet(7));
        }
        if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_9", new Boolean(this.isSet(8)));
            }
            return new Boolean(this.isSet(8));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "Name not recognized by ReasonFlags");
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(UNUSED)) {
            this.set(0, false);
        } else if (name.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, false);
        } else if (name.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, false);
        } else if (name.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, false);
        } else if (name.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, false);
        } else if (name.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, false);
        } else if (name.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, false);
        } else if (name.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, false);
        } else if (name.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, false);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Name not recognized by ReasonFlags");
            }
            throw new IOException("Name not recognized by ReasonFlags");
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        String s2;
        block13: {
            s2 = "Reason Flags [\n";
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            try {
                if (this.isSet(0)) {
                    s2 = s2 + "  Unused\n";
                }
                if (this.isSet(1)) {
                    s2 = s2 + "  Key Compromise\n";
                }
                if (this.isSet(2)) {
                    s2 = s2 + "  CA_Compromise\n";
                }
                if (this.isSet(3)) {
                    s2 = s2 + "  Affiliation_Changed\n";
                }
                if (this.isSet(4)) {
                    s2 = s2 + "  Superseded\n";
                }
                if (this.isSet(5)) {
                    s2 = s2 + "  Cessation Of Operation\n";
                }
                if (this.isSet(6)) {
                    s2 = s2 + "  Certificate Hold\n";
                }
                if (this.isSet(7)) {
                    s2 = s2 + "  Privilege Withdrawn\n";
                }
                if (this.isSet(8)) {
                    s2 = s2 + "  AA Compromise\n";
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (debug == null) break block13;
                debug.exception(16384L, className, "toString", ex);
            }
        }
        s2 = s2 + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s2);
        }
        return s2;
    }

    public BitArray getReasonFlags() {
        if (debug != null) {
            debug.entry(16384L, className, "getReasonFlags");
            debug.exit(16384L, (Object)className, "getReasonFlags", new BitArray(this.bitString));
        }
        return new BitArray(this.bitString);
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putNamedBitString(new BitArray(this.bitString));
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(UNUSED);
        elements.addElement(KEY_COMPROMISE);
        elements.addElement(CA_COMPROMISE);
        elements.addElement(AFFLIATION_CHANGED);
        elements.addElement(SUPERSEDED);
        elements.addElement(CESSATION_OF_OPERATION);
        elements.addElement(CERTIFICATE_HOLD);
        elements.addElement(PRIVILEGE_WITHDRAWN);
        elements.addElement(AA_COMPROMISE);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }
}

