/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public final class RFC822Name
implements GeneralNameInterface {
    private String name;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.RFC822Name";

    public RFC822Name(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RFC822Name", derValue);
        }
        this.name = derValue.getIA5String();
        this.parseName(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "RFC822Name");
        }
    }

    public RFC822Name(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RFC822Name", name);
            debug.exit(16384L, className, "RFC822Name");
        }
        this.parseName(name);
        this.name = name;
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 1);
        }
        return 1;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putIA5String(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "RFC822Name: " + this.name);
        }
        return "RFC822Name: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    private void parseName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("RFC822Name may not be null or empty");
        }
        String domain = name.substring(name.indexOf(64) + 1);
        if (domain.length() == 0) {
            throw new IOException("RFC822Name may not end with @");
        }
        if (domain.startsWith(".") && domain.length() == 1) {
            throw new IOException("RFC822Name domain may not be just .");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RFC822Name)) {
            return false;
        }
        RFC822Name other = (RFC822Name)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int ndx;
        int inNdx;
        String thisName;
        String inName;
        int constraintType = inputName == null ? -1 : (inputName.getType() != 1 ? -1 : ((inName = ((RFC822Name)inputName).getName().toLowerCase()).equals(thisName = this.name.toLowerCase()) ? 0 : (thisName.endsWith(inName) ? (inName.indexOf(64) != -1 ? 3 : (inName.startsWith(".") ? 2 : (thisName.charAt((inNdx = thisName.lastIndexOf(inName)) - 1) == '@' ? 2 : 3))) : (inName.endsWith(thisName) ? (thisName.indexOf(64) != -1 ? 3 : (thisName.startsWith(".") ? 1 : (inName.charAt((ndx = inName.lastIndexOf(thisName)) - 1) == '@' ? 1 : 3))) : 3))));
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        String subtree = this.name;
        int i2 = 1;
        int atNdx = subtree.lastIndexOf(64);
        if (atNdx >= 0) {
            ++i2;
            subtree = subtree.substring(atNdx + 1);
        }
        while (subtree.lastIndexOf(46) >= 0) {
            subtree = subtree.substring(0, subtree.lastIndexOf(46));
            ++i2;
        }
        return i2;
    }
}

