/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.calendar;

import com.ibm.security.util.calendar.CalendarDate;
import com.ibm.security.util.calendar.CalendarSystem;
import com.ibm.security.util.calendar.Gregorian;
import java.util.Locale;
import java.util.TimeZone;

public class Era {
    private final String name;
    private final String abbr;
    private final long since;
    private final CalendarDate sinceDate;
    private final boolean localTime;
    private int hash = 0;

    protected Era(String name, String abbr, long since, boolean localTime) {
        this.name = name;
        this.abbr = abbr;
        this.since = since;
        this.localTime = localTime;
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        this.sinceDate = gcal.newCalendarDate(null);
        gcal.getCalendarDate(since, this.sinceDate);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName(Locale locale) {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public String getDiaplayAbbreviation(Locale locale) {
        return this.abbr;
    }

    public long getSince(TimeZone zone) {
        if (zone == null || !this.localTime) {
            return this.since;
        }
        int offset = zone.getOffset(this.since);
        return this.since + (long)offset;
    }

    public CalendarDate getSinceDate() {
        return (CalendarDate)this.sinceDate.clone();
    }

    public boolean isLocalTime() {
        return this.localTime;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Era)) {
            return false;
        }
        Era that = (Era)o2;
        return this.name.equals(that.name) && this.abbr.equals(that.abbr) && this.since == that.since && this.localTime == that.localTime;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.name.hashCode() ^ this.abbr.hashCode() ^ (int)this.since ^ (int)(this.since >> 32) ^ (this.localTime ? 1 : 0);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append('[');
        sb2.append(this.getName()).append(" (");
        sb2.append(this.getAbbreviation()).append(')');
        sb2.append(" since ").append(this.getSinceDate());
        if (this.localTime) {
            sb2.setLength(sb2.length() - 1);
            sb2.append(" local time");
        }
        sb2.append(']');
        return sb2.toString();
    }
}

