/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.util.GAEUtils;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.view.facelets.util.Classpath;

public class DefaultFacesConfigResourceProvider
extends FacesConfigResourceProvider {
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";

    @Override
    public Collection<URL> getMetaInfConfigurationResources(ExternalContext context) throws IOException {
        ArrayList<URL> urlSet = new ArrayList<URL>();
        Enumeration<URL> resources = this.getClassLoader().getResources(FACES_CONFIG_IMPLICIT);
        while (resources.hasMoreElements()) {
            urlSet.add(resources.nextElement());
        }
        String jarFilesToScanParam = MyfacesConfig.getCurrentInstance((ExternalContext)context).getGaeJsfJarFiles();
        String string = jarFilesToScanParam = jarFilesToScanParam != null ? jarFilesToScanParam.trim() : null;
        if (ContainerUtils.isRunningOnGoogleAppEngine(context) && jarFilesToScanParam != null && jarFilesToScanParam.length() > 0) {
            Collection<URL> urlsGAE = GAEUtils.searchInWebLib(context, this.getClassLoader(), jarFilesToScanParam, META_INF_PREFIX, FACES_CONFIG_SUFFIX);
            if (urlsGAE != null) {
                urlSet.addAll(urlsGAE);
            }
        } else {
            URL[] urls = Classpath.search(this.getClassLoader(), META_INF_PREFIX, FACES_CONFIG_SUFFIX);
            for (int i = 0; i < urls.length; ++i) {
                urlSet.add(urls[i]);
            }
        }
        return urlSet;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }
}

