/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.cache.DynamicCacheAccessor;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.CacheConfig;
import com.ibm.websphere.servlet.cache.ConfigElement;
import com.ibm.websphere.servlet.cache.IdGenerator;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.servlet.ConfigElementImpl;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class DefaultIdGeneratorImpl
implements IdGenerator {
    private static TraceComponent tc = Tr.register(DefaultIdGeneratorImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    String name = null;
    int sharingPolicy = ServerCache.getSharingPolicy();
    boolean external = false;
    HashMap reqParmHash = null;
    ConfigElement[] invalidations = null;
    boolean invalidateonly = false;
    ConfigElement[] requestParameters = null;
    ConfigElement[] requestAttributes = null;
    ConfigElement[] sessionParameters = null;
    ConfigElement[] cookies = null;
    protected Method[] rAttrMethodCache = null;
    protected Method[] sParamMethodCache = null;

    @Override
    public String getId(ServletCacheRequest request) {
        String encoding;
        boolean debugEnabled = tc.isDebugEnabled();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> invalidations = new ArrayList<String>();
        ArrayList<String> dataIds = new ArrayList<String>();
        boolean buildId = true;
        if (this.external) {
            String queryString;
            if (debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"Special id processing for this exteranally cacheable servlet...", (Object[])new Object[0]);
            }
            Enumeration parms = request.getParameterNames();
            while (parms.hasMoreElements()) {
                String parm = (String)parms.nextElement();
                ConfigElement ce = (ConfigElement)this.reqParmHash.get(parm);
                String[] values = request.getParameterValues(parm);
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (ce == null) continue;
                    if (ce.exclude != null && ce.exclude.contains(values[i])) {
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)(ce.id + " has value " + value + " present on request, and is marked \"exclude\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                        }
                        buildId = false;
                    }
                    if (ce.invalidate != null) {
                        invalidations.add(new StringBuffer(ce.invalidate).append("=").append(value).toString());
                    }
                    if (ce.dataId == null) continue;
                    if (debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)("adding data id " + ce.dataId), (Object[])new Object[0]);
                    }
                    dataIds.add(new StringBuffer(ce.dataId).append("=").append(value).toString());
                }
            }
            if (buildId && (queryString = request.getQueryString()) != null) {
                sb.append("?").append(queryString);
            }
        } else {
            ConfigElementImpl ce;
            ConfigElementImpl ce2;
            block97: {
                if (this.name != null && !this.name.equals("")) {
                    sb.append(this.name).append(":");
                }
                try {
                    if (this.requestParameters == null) break block97;
                    for (int i = 0; i < this.requestParameters.length; ++i) {
                        ce2 = (ConfigElementImpl)this.requestParameters[i];
                        String[] vals = request.getParameterValues(ce2.id);
                        if (ce2.excludeAll && vals != null) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)(ce2.id + " present on request, and is marked \"Exclude All\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                            }
                            buildId = false;
                        }
                        if (vals != null) {
                            for (int j = 0; j < vals.length; ++j) {
                                String value = vals[j];
                                if (ce2.exclude != null && ce2.exclude.contains(value)) {
                                    if (debugEnabled) {
                                        Tr.debug((TraceComponent)tc, (String)(ce2.id + " has value " + value + " present on request, and is marked \"exclude\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                                    }
                                    buildId = false;
                                }
                                if (ce2.ignoreValue) {
                                    if (debugEnabled) {
                                        Tr.debug((TraceComponent)tc, (String)("ignoring value of " + ce2.id), (Object[])new Object[0]);
                                    }
                                    value = "";
                                }
                                if (buildId) {
                                    sb.append(ce2.id).append("=").append(value).append(":");
                                }
                                if (ce2.invalidate != null) {
                                    invalidations.add(new StringBuffer(ce2.invalidate).append("=").append(value).toString());
                                }
                                if (!buildId || ce2.dataId == null) continue;
                                if (debugEnabled) {
                                    Tr.debug((TraceComponent)tc, (String)("adding data id " + ce2.dataId), (Object[])new Object[0]);
                                }
                                dataIds.add(new StringBuffer(ce2.dataId).append("=").append(value).toString());
                            }
                            continue;
                        }
                        if (!ce2.required) continue;
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)(ce2 + "\" missing from request. Not Caching."), (Object[])new Object[0]);
                        }
                        return null;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"194", (Object)this);
                    if (!debugEnabled) break block97;
                    Tr.debug((TraceComponent)tc, (String)("problem getting params: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (this.requestAttributes != null) {
                for (int i = 0; i < this.requestAttributes.length; ++i) {
                    ce2 = (ConfigElementImpl)this.requestAttributes[i];
                    Object o = request.getAttribute(ce2.id);
                    if (ce2.excludeAll && o != null) {
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)(ce2.id + " present on request, and is marked \"Exclude All\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                        }
                        buildId = false;
                    }
                    Method m = null;
                    if (o != null) {
                        if (this.rAttrMethodCache[i] != null) {
                            m = this.rAttrMethodCache[i];
                        } else {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)("caching " + ce2.id + "." + ce2.method + "()"), (Object[])new Object[0]);
                            }
                            try {
                                m = o.getClass().getMethod(ce2.method, new Class[0]);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"224", (Object)this);
                                if (ce2.required) {
                                    if (debugEnabled) {
                                        Tr.debug((TraceComponent)tc, (String)("Required object " + ce2.id + "\" was missing method \"" + ce2.method + "\". Not Caching."), (Object[])new Object[0]);
                                    }
                                    return null;
                                }
                                if (!debugEnabled) continue;
                                Tr.debug((TraceComponent)tc, (String)(ce2.id + "\" was missing method \"" + ce2.method + "\". Continuing."), (Object[])new Object[0]);
                                continue;
                            }
                            this.rAttrMethodCache[i] = m;
                        }
                        String result = null;
                        Object tmp = null;
                        try {
                            tmp = m.invoke(o, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"242", (Object)this);
                        }
                        catch (IllegalAccessException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"245", (Object)this);
                        }
                        if (tmp != null) {
                            result = tmp.toString();
                        }
                        if (ce2.exclude != null && ce2.exclude.contains(result)) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)(ce2.id + "." + ce2.method + "() has value " + result + " present on request, and is marked \"exclude\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                            }
                            buildId = false;
                        }
                        if (ce2.ignoreValue) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)("ignoring value of " + ce2.id), (Object[])new Object[0]);
                            }
                            result = "";
                        }
                        if (buildId) {
                            sb.append(ce2.id).append(".").append(ce2.method).append("=").append(result).append(":");
                        }
                        if (result == null) continue;
                        if (ce2.invalidate != null) {
                            invalidations.add(new StringBuffer(ce2.invalidate).append("=").append(result).toString());
                        }
                        if (!buildId || ce2.dataId == null) continue;
                        dataIds.add(new StringBuffer(ce2.dataId).append("=").append(result).toString());
                        continue;
                    }
                    if (!ce2.required) continue;
                    if (debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)(ce2 + "\" missing from request. Not Caching."), (Object[])new Object[0]);
                    }
                    return null;
                }
            }
            if (this.sessionParameters != null) {
                HttpSession session = request.getSession(false);
                for (int i = 0; i < this.sessionParameters.length; ++i) {
                    ce = (ConfigElementImpl)this.sessionParameters[i];
                    if (session == null) {
                        if (ce.required) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)("No session exists, but session parameter \"" + ce.id + "\" is required. Not Caching."), (Object[])new Object[0]);
                            }
                            return null;
                        }
                        if (!debugEnabled) continue;
                        Tr.debug((TraceComponent)tc, (String)("No session exists, ignoring session parameter \"" + ce.id), (Object[])new Object[0]);
                        continue;
                    }
                    Object o = session.getAttribute(ce.id);
                    if (ce.excludeAll && o != null) {
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)(ce.id + " present on request, and is marked \"Exclude All\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                        }
                        buildId = false;
                    }
                    Method m = null;
                    if (o != null) {
                        if (this.sParamMethodCache[i] != null) {
                            m = this.sParamMethodCache[i];
                        } else {
                            try {
                                m = o.getClass().getMethod(ce.method, new Class[0]);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"321", (Object)this);
                                if (ce.required) {
                                    if (debugEnabled) {
                                        Tr.debug((TraceComponent)tc, (String)("required session parameter \"" + ce.id + "\" was missing method \"" + ce.method + "\". Not Caching."), (Object[])new Object[0]);
                                    }
                                    return null;
                                }
                                if (!debugEnabled) continue;
                                Tr.debug((TraceComponent)tc, (String)("sesison parameter \"" + ce.id + "\" was missing method \"" + ce.method + "\".  Continuing."), (Object[])new Object[0]);
                                continue;
                            }
                            this.sParamMethodCache[i] = m;
                        }
                        String result = null;
                        Object tmp = null;
                        try {
                            tmp = m.invoke(o, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"339", (Object)this);
                        }
                        catch (IllegalAccessException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.DefaultIdGeneratorImpl.getId", (String)"342", (Object)this);
                        }
                        if (tmp != null) {
                            result = tmp.toString();
                        }
                        if (ce.exclude != null && ce.exclude.contains(result)) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)(ce.id + "." + ce.method + "() has value " + result + " present on request, and is marked \"exclude\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                            }
                            buildId = false;
                        }
                        if (ce.ignoreValue) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)("ignoring value of " + ce.id), (Object[])new Object[0]);
                            }
                            result = "";
                        }
                        if (buildId) {
                            sb.append(ce.id).append(".").append(ce.method).append("=").append(result).append(":");
                        }
                        if (result == null) continue;
                        if (ce.invalidate != null) {
                            invalidations.add(new StringBuffer(ce.invalidate).append("=").append(result).toString());
                        }
                        if (!buildId || ce.dataId == null) continue;
                        dataIds.add(new StringBuffer(ce.dataId).append("=").append(result).toString());
                        continue;
                    }
                    if (!ce.required) continue;
                    if (debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)("required session parameter \"" + ce.id + "\" missing from session. Not Caching."), (Object[])new Object[0]);
                    }
                    return null;
                }
            }
            if (this.cookies != null) {
                Cookie[] cookieArray = request.getCookies();
                for (int i = 0; i < this.cookies.length; ++i) {
                    ce = (ConfigElementImpl)this.cookies[i];
                    boolean found = false;
                    int j = 0;
                    if (cookieArray.length > 0) {
                        while (!(found = cookieArray[j].getName().equals(ce.id)) && ++j < cookieArray.length) {
                        }
                    }
                    if (found) {
                        if (ce.excludeAll) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)(ce.id + " present on request, and is marked \"Exclude All\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                            }
                            buildId = false;
                        }
                        String value = cookieArray[j].getValue();
                        if (ce.exclude != null && ce.exclude.contains(value)) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)(ce.id + " has value " + value + " present on request, and is marked \"exclude\". Not Caching, though processing will continue to find invalidations."), (Object[])new Object[0]);
                            }
                            buildId = false;
                        }
                        if (ce.ignoreValue) {
                            if (debugEnabled) {
                                Tr.debug((TraceComponent)tc, (String)("ignoring value of " + ce.id), (Object[])new Object[0]);
                            }
                            value = "";
                        }
                        if (buildId) {
                            sb.append(ce.id).append("=").append(value).append(":");
                        }
                        if (ce.invalidate != null) {
                            invalidations.add(new StringBuffer(ce.invalidate).append("=").append(value).toString());
                        }
                        if (!buildId || ce.dataId == null) continue;
                        if (debugEnabled) {
                            Tr.debug((TraceComponent)tc, (String)("adding data id " + ce.dataId), (Object[])new Object[0]);
                        }
                        dataIds.add(new StringBuffer(ce.dataId).append("=").append(value).toString());
                        continue;
                    }
                    if (!ce.required) continue;
                    if (debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)(ce + "\" missing from request. Not Caching."), (Object[])new Object[0]);
                    }
                    return null;
                }
            }
        }
        if (invalidations.size() > 0) {
            this.processInvalidationList(invalidations);
            if (debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"processed all invalidations, excluding this entry from caching", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.invalidateonly || !buildId) {
            return null;
        }
        if (dataIds.size() > 0) {
            this.processDataIds(dataIds, request);
            if (debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)"processed all dataids", (Object[])new Object[0]);
            }
        }
        if ((encoding = request.getCharacterEncoding()) != null) {
            sb.append(encoding);
        }
        String out = sb.toString();
        if (debugEnabled) {
            Tr.debug((TraceComponent)tc, (String)("generated cacheId " + out), (Object[])new Object[0]);
        }
        if (out.equals("")) {
            return null;
        }
        return out;
    }

    @Override
    public int getSharingPolicy(ServletCacheRequest request) {
        return this.sharingPolicy;
    }

    @Override
    public void initialize(CacheConfig cc) {
        this.name = cc.getName();
        this.sharingPolicy = cc.getSharingPolicy();
        boolean bl = this.external = cc.getExternalCache() != null;
        if (this.external) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This servlet is externally cacheable, creating the hash of request parameter elements", (Object[])new Object[0]);
            }
            this.reqParmHash = new HashMap();
            this.requestParameters = cc.getRequestParameters();
            if (this.requestParameters != null) {
                int i;
                for (i = 0; i < this.requestParameters.length; ++i) {
                    this.reqParmHash.put(this.requestParameters[i].id, this.requestParameters[i]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Finished...created " + i + " parameters in the hash"), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No request parameters...using an empty hash", (Object[])new Object[0]);
            }
        } else {
            this.invalidateonly = cc.getInvalidateonly();
            this.requestParameters = cc.getRequestParameters();
            this.requestAttributes = cc.getRequestAttributes();
            this.sessionParameters = cc.getSessionParameters();
            this.cookies = cc.getCookies();
            if (this.requestAttributes != null) {
                this.rAttrMethodCache = new Method[this.requestAttributes.length];
            }
            if (this.sessionParameters != null) {
                this.sParamMethodCache = new Method[this.sessionParameters.length];
            }
        }
    }

    void processInvalidationList(ArrayList invalidations) {
        for (int i = 0; i < invalidations.size(); ++i) {
            DynamicCacheAccessor.getCache().invalidateById((String)invalidations.get(i), i == invalidations.size() - 1);
        }
    }

    void processDataIds(ArrayList dataIds, ServletCacheRequest request) {
        FragmentInfo fragmentInfo = (FragmentInfo)request.getFragmentInfo();
        for (int i = 0; i < dataIds.size(); ++i) {
            fragmentInfo.addDataId((String)dataIds.get(i));
        }
    }
}

