/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs20.security.SecurityContextProxy;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Priority;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

@Priority(value=2000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertySimpleAuthorizingInterceptor
extends AbstractAuthorizingInInterceptor {
    private static final TraceComponent tc = Tr.register(LibertySimpleAuthorizingInterceptor.class, null, null);
    static final long serialVersionUID = 3077822115520915884L;

    @Override
    public void handleMessage(Message message) throws Fault {
        SecurityContext cxfSecurityContext = message.get(SecurityContext.class);
        javax.ws.rs.core.SecurityContext jaxrsSecurityContext = message.get(javax.ws.rs.core.SecurityContext.class);
        if (jaxrsSecurityContext != null) {
            SecurityContextProxy securityContextProxy = new SecurityContextProxy(jaxrsSecurityContext);
            Method method = this.getTargetMethod(message);
            if (this.parseMethodSecurity(method, securityContextProxy)) {
                return;
            }
        } else if (cxfSecurityContext != null) {
            SecurityContextProxy securityContextProxy = new SecurityContextProxy(cxfSecurityContext);
            Method method = this.getTargetMethod(message);
            if (this.parseMethodSecurity(method, securityContextProxy)) {
                return;
            }
        }
        throw new AccessDeniedException("Unauthorized");
    }

    private boolean ensureAuthentication(SecurityContext sc) {
        Principal p = sc.getUserPrincipal();
        if (p == null || "UNAUTHENTICATED".equals(p.getName())) {
            throw new AuthenticationException();
        }
        return true;
    }

    private boolean parseMethodSecurity(Method method, SecurityContext sc) {
        boolean denyAll = this.getDenyAll(method);
        if (denyAll) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found DenyAll for method: {} " + method.getName() + ", Injection Processing for web service is ignored"), (Object[])new Object[0]);
            }
            return false;
        }
        RolesAllowed rolesAllowed = this.getRolesAllowed(method);
        if (rolesAllowed != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found RolesAllowed in method: {} " + method.getName()), (Object[])new Object[]{rolesAllowed.value()});
            }
            if (!this.ensureAuthentication(sc)) {
                return false;
            }
            String[] theseroles = rolesAllowed.value();
            return this.isUserInRole(sc, Arrays.asList(theseroles), false);
        }
        boolean permitAll = this.getPermitAll(method);
        if (permitAll) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found PermitAll for method: {}" + method.getName()), (Object[])new Object[0]);
            }
            return true;
        }
        Class<?> cls = method.getDeclaringClass();
        return this.parseClassSecurity(cls, sc);
    }

    private boolean parseClassSecurity(Class<?> cls, SecurityContext sc) {
        DenyAll denyAll = cls.getAnnotation(DenyAll.class);
        if (denyAll != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found class level @DenyAll - authorization denied for " + cls.getName()), (Object[])new Object[0]);
            }
            return false;
        }
        RolesAllowed rolesAllowed = cls.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            String[] theseroles = rolesAllowed.value();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found RolesAllowed in class level: {} " + cls.getName()), (Object[])new Object[]{theseroles});
            }
            if (!this.ensureAuthentication(sc)) {
                return false;
            }
            return this.isUserInRole(sc, Arrays.asList(theseroles), false);
        }
        return true;
    }

    private RolesAllowed getRolesAllowed(Method method) {
        return method.getAnnotation(RolesAllowed.class);
    }

    private boolean getPermitAll(Method method) {
        return method.isAnnotationPresent(PermitAll.class);
    }

    private boolean getDenyAll(Method method) {
        return method.isAnnotationPresent(DenyAll.class);
    }

    @Override
    protected List<String> getExpectedRoles(Method method) {
        return null;
    }
}

