/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class DigestInfo
extends PKCSDerObject
implements Cloneable {
    private AlgorithmId alg;
    private byte[] digest;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.DigestInfo";
    private volatile int cachedHashVal = 0;

    public DigestInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DigestInfo", (Object)der);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "DigestInfo", der, provider);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String algname, AlgorithmParameters params, byte[] digest) throws IOException, NoSuchAlgorithmException {
        this(algname, params, digest, null);
        if (debug != null) {
            Object[] parms = new Object[]{algname, params, digest};
            debug.entry(16384L, (Object)className, "DigestInfo", parms);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String algname, AlgorithmParameters params, byte[] digest, String provider) throws IOException, NoSuchAlgorithmException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{algname, params, digest, provider};
            debug.entry(16384L, (Object)className, "DigestInfo", parms);
        }
        if (algname == null || algname.length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "DigestInfo", "Algorithm must be specified");
            }
            throw new IllegalArgumentException("Algorithm must be specified");
        }
        if (digest == null || digest.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "DigestInfo", "Digest must be specified");
            }
            throw new IllegalArgumentException("Digest must be specified");
        }
        AlgorithmId tmpAlgId = AlgorithmId.get(algname);
        byte[] encParams = null;
        try {
            if (params != null) {
                encParams = params.getEncoded();
            }
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "DigestInfo", e2);
            }
            throw new IllegalArgumentException("Algorithm parameters cannot be encoded.");
        }
        if (params == null) {
            this.alg = tmpAlgId;
        } else {
            ObjectIdentifier oid = tmpAlgId.getOID();
            this.alg = new AlgorithmId(oid, encParams, provider);
        }
        this.digest = digest;
        if (debug != null) {
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "DigestInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "DigestInfo", parms);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            DigestInfo result = new DigestInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.alg.encode(bytes);
        bytes.putOctetString(this.digest);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            throw new IOException("DigestInfo parsing error");
        }
        DerValue der = encoding.getData().getDerValue();
        this.alg = AlgorithmId.parse(der);
        this.digest = encoding.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof DigestInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((DigestInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.alg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.alg.getOID(), this.alg.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", result);
        }
        return result;
    }

    public byte[] getDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigest");
        }
        if (this.digest == null || this.digest.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigest", null);
            }
            return null;
        }
        byte[] digest2 = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, digest2, 0, this.digest.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigest", digest2);
        }
        return digest2;
    }

    @Override
    public String toString() {
        HexDumpEncoder hd = new HexDumpEncoder();
        String out = "";
        out = out + "Digest Info: ";
        out = out + "\r\n\talgorithm: " + this.alg;
        out = out + "\r\n\tdigest:\r\n";
        out = out + hd.encodeBuffer(this.digest);
        return out;
    }
}

