/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;

public final class PKCS12Utils {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12Utils";

    private PKCS12Utils() {
    }

    public static byte[] ascii2bmp(char[] chars) {
        byte[] bmpStr = new byte[]{};
        if (debug != null) {
            debug.entry(49152L, (Object)className, "ascii2bmp", (Object)chars);
        }
        if (chars == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "ascii2bmp_1", bmpStr);
            }
            return bmpStr;
        }
        if (chars.length > 0) {
            bmpStr = new byte[(chars.length + 1) * 2];
        }
        int i2 = 0;
        int j2 = 0;
        while (i2 < chars.length) {
            bmpStr[j2] = (byte)(chars[i2] >>> 8 & 0xFF);
            bmpStr[j2 + 1] = (byte)(chars[i2] & 0xFF);
            ++i2;
            j2 += 2;
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "ascii2bmp_2", bmpStr);
        }
        return bmpStr;
    }

    public static String bmp2string(byte[] bmp) {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "bmp2string", (Object)bmp);
        }
        if (bmp.length % 2 != 0) {
            if (debug != null) {
                debug.text(49152L, className, "bmp2string", "Invalid BMP array.");
            }
            throw new IllegalArgumentException("Invalid BMP array.");
        }
        char[] chars = new char[bmp.length / 2];
        int i2 = 0;
        int j2 = 0;
        while (i2 < bmp.length) {
            byte b1 = bmp[i2++];
            byte b2 = bmp[i2++];
            chars[j2] = (char)((b1 << 8 & 0xFF00) + (b2 & 0xFF));
            ++j2;
        }
        String str = new String(chars);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "bmp2string", str.trim());
        }
        return str.trim();
    }
}

