/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public final class TCPMsgV10ErrorMsgRep {
    private byte[] data;
    private byte majorErrorType;
    private byte minorErrorType;
    private byte errorMsgRep;
    private byte[] utf8String;
    private byte[] value;
    public static final byte VERSION_NEGOTIATION = 1;
    public static final byte CLIENT_ERRORS = 2;
    public static final byte SERVER_ERRORS = 3;
    public static final byte ERROR_MSG_REP_VERSION_NOT_SUPPORTED = 0;
    public static final byte ERROR_MSG_REP_GENERAL_CLIENT_ERROR = 1;
    public static final byte ERROR_MSG_REP_MESSAGE_TYPE_UNKNOWN = 2;
    public static final byte ERROR_MSG_REP_INVALID_POLL_ID = 3;
    public static final byte ERROR_MSG_REP_UNKNOWN = -1;

    public TCPMsgV10ErrorMsgRep(byte by, byte by2, byte[] byArray, String string) {
        this.setTCPMsgV10ErrorMsgRep(by, by2, byArray, TCPMsgV10ErrorMsgRep.stringToUtf(string));
    }

    public TCPMsgV10ErrorMsgRep(byte[] byArray) throws IOException {
        if (byArray.length < 4) {
            throw new IOException("TCPMsgV10ErrorMsgRep error : data too short");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte[] byArray4 = new byte[2];
        System.arraycopy(byArray, 2, byArray4, 0, 2);
        int n2 = new BigInteger(1, byArray4).intValue();
        if (by == 1 && by2 == 1) {
            if (n2 != 1) {
                throw new IOException("TCPMsgV10ErrorMsgRep parsing error : invalid data value");
            }
        } else if (by == 2 && by2 == 0) {
            if (n2 != 0) {
                throw new IOException("TCPMsgV10ErrorMsgRep parsing error : empty data expected");
            }
        } else if (by == 2 && by2 == 1 ? n2 != 1 : by == 2 && by2 == 2 && n2 != 4) {
            throw new IOException("TCPMsgV10ErrorMsgRep parsing error : invalid data value");
        }
        if (byArray.length - 4 < n2) {
            throw new IOException("TCPMsgV10ErrorMsgRep error : not enough data");
        }
        byArray2 = new byte[n2];
        System.arraycopy(byArray, 4, byArray2, 0, n2);
        int n3 = byArray.length - 4 - n2;
        if (n3 > 0) {
            byArray3 = new byte[n3];
            System.arraycopy(byArray, 4 + n2, byArray3, 0, n3);
        }
        this.setTCPMsgV10ErrorMsgRep(by, by2, byArray2, byArray3);
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return (byte[])this.data.clone();
    }

    public byte[] getEncoded() {
        if (this.value != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    public byte getMajorError() {
        return this.majorErrorType;
    }

    public byte getMinorError() {
        return this.minorErrorType;
    }

    public String getUtf8String() {
        if (this.utf8String == null) {
            return null;
        }
        try {
            return TCPMsgV10ErrorMsgRep.utfToString(this.utf8String, 0, this.utf8String.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void setTCPMsgV10ErrorMsgRep(byte by, byte by2, byte[] byArray, byte[] byArray2) {
        if (by < 0 || by > 3) {
            throw new IllegalArgumentException("TCPMsgV10ErrorMsgRep error : invalid major error");
        }
        if (by2 < 0 || by2 > 3) {
            throw new IllegalArgumentException("TCPMsgV10ErrorMsgRep error : invalid minor error");
        }
        this.majorErrorType = by;
        this.minorErrorType = by2;
        if (by == 1 && by2 == 1) {
            if (byArray == null || byArray.length != 1) {
                throw new IllegalArgumentException("TCPMsgV10ErrorMsgRep error : invalid data value");
            }
        } else if (by == 2 && by2 == 0) {
            if (byArray != null && byArray.length != 0) {
                throw new IllegalArgumentException("TCPMsgV10ErrorMsgRep error : empty data expected");
            }
        } else if (by == 2 && by2 == 1 ? byArray == null || byArray.length != 1 : by == 2 && by2 == 2 && (byArray == null || byArray.length != 4)) {
            throw new IllegalArgumentException("TCPMsgV10ErrorMsgRep error : invalid data value");
        }
        int n2 = 4;
        if (byArray != null) {
            this.data = (byte[])byArray.clone();
            n2 += this.data.length;
        } else {
            this.data = null;
        }
        if (byArray2 != null) {
            this.utf8String = byArray2;
            n2 += this.utf8String.length;
        } else {
            this.utf8String = null;
        }
        this.value = new byte[n2];
        this.value[0] = this.majorErrorType;
        this.value[1] = this.minorErrorType;
        byte[] byArray3 = null;
        if (this.data != null) {
            byArray3 = BigInteger.valueOf(this.data.length).toByteArray();
            if (byArray3.length < 2) {
                this.value[2] = 0;
                this.value[3] = byArray3.length == 0 ? (byte)0 : byArray3[byArray3.length - 1];
            } else {
                this.value[2] = byArray3[byArray3.length - 2];
                this.value[3] = byArray3[byArray3.length - 1];
            }
        } else {
            this.value[2] = 0;
            this.value[3] = 0;
        }
        int n3 = 4;
        if (this.data != null) {
            System.arraycopy(this.data, 0, this.value, n3, this.data.length);
        }
        if (this.data != null) {
            n3 += this.data.length;
        }
        if (this.utf8String != null) {
            System.arraycopy(this.utf8String, 0, this.value, n3, this.utf8String.length);
        }
    }

    private static byte[] stringToUtf(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public String toString() {
        String string = "\r\nError type :" + this.majorErrorType + " " + this.minorErrorType;
        if (this.data != null) {
            string = String.valueOf(string) + "\r\nData = " + new String(this.data);
        }
        if (this.utf8String != null) {
            string = String.valueOf(string) + "\r\nUTF8String = " + new String(this.utf8String);
        }
        return string;
    }

    private static String utfToString(byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        return new String(byArray, n2, n3, "UTF8");
    }
}

