/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertTemplate;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.ReasonFlags;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.util.Date;

public final class RevDetails
extends CMPDerObject {
    private CertTemplate certDetails;
    private ReasonFlags revocationReason;
    private Date badSinceDate;
    private CRLExtensions crlEntryDetails;

    public RevDetails(CertTemplate certTemplate, ReasonFlags reasonFlags, Date date, CRLExtensions cRLExtensions) {
        if (certTemplate == null) {
            throw new IllegalArgumentException("RevDetails error, cert details not specified");
        }
        this.certDetails = certTemplate;
        this.revocationReason = reasonFlags;
        this.badSinceDate = date;
        this.crlEntryDetails = cRLExtensions;
    }

    public RevDetails(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new RevDetails(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("RevDetails parsing error, not a SEQUENCE");
        }
        this.certDetails = null;
        this.revocationReason = null;
        this.badSinceDate = null;
        this.crlEntryDetails = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("RevDetails parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.certDetails = new CertTemplate(derValue2.toByteArray());
        if (derValue.getData().available() == 0) {
            return;
        }
        derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 3) {
            this.revocationReason = new ReasonFlags(derValue2);
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                return;
            }
        }
        if (derValue2.getTag() == 24) {
            this.badSinceDate = new DerInputStream(derValue2.toByteArray()).getGeneralizedTime();
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
            } else {
                return;
            }
        }
        try {
            this.crlEntryDetails = new CRLExtensions(new DerInputStream(derValue2.toByteArray()));
        }
        catch (CRLException cRLException) {
            throw new IOException("RevDetails parsing error, " + cRLException);
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("RevDetails parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certDetails == null) {
            throw new IOException("RevDetails encoding error, cert details not specified");
        }
        this.certDetails.encode(derOutputStream);
        if (this.revocationReason != null) {
            this.revocationReason.encode(derOutputStream);
        }
        if (this.badSinceDate != null) {
            derOutputStream.putGeneralizedTime(this.badSinceDate);
        }
        if (this.crlEntryDetails != null) {
            try {
                this.crlEntryDetails.encode(derOutputStream, true);
            }
            catch (CRLException cRLException) {
                throw new IOException("RevDetails encoding error, " + cRLException);
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(RevDetails revDetails) {
        DerValue derValue;
        DerValue derValue2;
        if (revDetails == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            revDetails.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RevDetails) {
            return this.equals((RevDetails)object);
        }
        return false;
    }

    public Date getBadSinceDate() {
        if (this.badSinceDate == null) {
            return null;
        }
        return new Date(this.badSinceDate.getTime());
    }

    public CertTemplate getCertDetails() {
        return (CertTemplate)this.certDetails.clone();
    }

    public CRLExtensions getCrlEntryDetails() throws IOException {
        if (this.crlEntryDetails == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.crlEntryDetails.encode(derOutputStream, true);
            return new CRLExtensions(new DerInputStream(derOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public ReasonFlags getReason() throws IOException {
        if (this.revocationReason == null) {
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.revocationReason.encode(derOutputStream);
        return new ReasonFlags(new DerInputStream(derOutputStream.toByteArray()));
    }

    public String toString() {
        String string = "RevDetails:\r\n";
        string = String.valueOf(string) + "\r\n\tCert Details: " + this.certDetails;
        if (this.revocationReason != null) {
            string = String.valueOf(string) + "\r\n\trevocation reason: " + this.revocationReason;
        }
        if (this.badSinceDate != null) {
            string = String.valueOf(string) + "\r\n\tbad since date: " + this.badSinceDate;
        }
        if (this.crlEntryDetails != null) {
            string = String.valueOf(string) + "\r\n\tcrl entry details: " + this.crlEntryDetails;
        }
        return string;
    }
}

