@ECHO OFF
CLS

set /p portnumber=<config.txt

SET "port=%portnumber:~5%"



echo Welcome to Application Modernization Accelerator
echo:
echo ---------------------------------------------------------
setlocal


for /f "tokens=1" %%a in ('podman ps -a ^| findstr "db"') do set db=%%a
for /f "tokens=1" %%b in ('podman ps -a ^| findstr "ui"') do set ui=%%b
for /f "tokens=1" %%c in ('podman ps -a ^| findstr "neo4j"') do set neo4j=%%c
for /f "tokens=1" %%d in ('podman ps -a ^| findstr "server"') do set server=%%d
echo:

if exist license_accepted.txt (
        goto ama:
)

echo Select from the menu which license you are installing this product under
echo ---------------------------------------------------------------------------
echo:
echo 1. IBM Application Modernization Accelerator 4.3 (Evaluation) - L-UZDR-J82CTJ
echo:

set /p lic=Type option:
if "%lic%"=="1" goto accept

:accept
echo:
echo 1. I have read and agreed to the license agreements
echo 2. Don't accept the license agreements
echo:

set /p acc=Type option:
if "%acc%"=="1" goto ama
if "%acc%"=="2" goto op7

:ama
echo "license accepted" > license_accepted.txt

if not "%db%"=="" (
        for /L %%A in (1,1,5) do (<nul set /p "=."& >nul timeout 1)
        echo Database container running
        echo:
        podman start %db% > null
        rem timeout 10 > null
        for /L %%A in (1,1,5) do (<nul set /p "=."& >nul timeout 1)
        goto :ui
) else (
        echo Application Modernization Accelerator container not running
        echo:
        goto :NotRunning
)

:ui
if not "%ui%"=="" (
        echo UI container running
        echo:
        podman start %ui% > null
        for /L %%A in (1,1,5) do (<nul set /p "=."& >nul timeout 1)
        rem timeout 10 > null
        goto :server
) else (
        echo:
        echo Application Modernization Accelerator container not running
        goto :NotRunning
)

:server

if not "%server%"=="" (
        echo Server container running
        echo:
        podman start %server% > null
        for /L %%A in (1,1,5) do (<nul set /p "=."& >nul timeout 1)
        rem timeout 10 > null
        goto :neo4j
) else (
        echo:
        echo Application Modernization Accelerator container not running
        goto :NotRunning
)

:neo4j
if not "%neo4j%"=="" (
        echo Neo4j container running
        echo:
        podman start %neo4j% > null
        rem timeout 10 > null
) else (
        echo:
        echo Application Modernization Accelerator container not running
        goto :NotRunning
)


:Running

for /f "tokens=3 delims=: " %%e in ('podman ps' ) do set version=%%e
echo:
echo Application Modernization Accelerator containers are running
echo:
echo Application Modernization Accelerator %version% can be accessed at: http://localhost:%port%
echo:
goto :NotRunning

:NotRunning
echo:
echo Select operation below:
echo:
ECHO 1. Install Application Modernization Accelerator
ECHO 2. Uninstall Application Modernization Accelerator - keep data
ECHO 3. Uninstall Application Modernization Accelerator - remove data
ECHO 4. Stop Application Modernization Accelerator
ECHO 5. Start Application Modernization Accelerator
ECHO 6. Re-initialize Configuration
ECHO 7. Gathering Debug Information
ECHO 8. Working in Air Gap Environment
ECHO 9. Exit
ECHO.

set /p op=Type option:
if "%op%"=="1" goto op1
if "%op%"=="2" goto op2
if "%op%"=="3" goto op3
if "%op%"=="4" goto op4
if "%op%"=="5" goto op5
if "%op%"=="6" goto op6
if "%op%"=="7" goto op7
if "%op%"=="8" goto op8
if "%op%"=="9" goto op9

:op1
ECHO Install Application Modernization Accelerator
install.bat
goto begin

:op2
ECHO Uninstalling Application Modernization Accelerator
uninstallkeepData.bat
goto begin

:op3
ECHO Uninstalling Application Modernization Accelerator
uninstall.bat
goto begin

:op4
ECHO Stopping Application Modernization Accelerator
stop.bat
goto begin

:op5
ECHO Starting Application Modernization Accelerator
start.bat
goto begin


:op6
ECHO Reconfiguring  Application Modernization Accelerator
Re-initialize.bat
goto begin

:op7
ECHO Gathering Debug Information
debugReport.bat
goto begin

:op8
airGap.bat
goto begin

:op9
exit /B 5

:eof
:exit
@exit
