#!/usr/bin/env bash
# Created by Huang, Fuguo (aka ken) on 23.2.2021.

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

# generate the cert based on the host name showed in Status
source ./logging.sh
function generateKeyAndCert {
	log "Starting: Generating key and cert"

    openssl rand -out ~/.rnd 128
	ssl_config=openssl.cnf

	cert_subj=$(cat <<EOF
/C=IE
/ST=Cork
/L=Cork
/emailAddress=Transformation.Advisor@ie.ibm.com
/O=TA
/OU=TA
/CN=ta.server.local
EOF
	)

	# Add Extensions
	cert_custom=$(cat <<EOF
[ ta_cert_extensions ]
subjectKeyIdentifier=hash
authorityKeyIdentifier=keyid:always,issuer
basicConstraints = critical,CA:false
keyUsage = digitalSignature, keyEncipherment
extendedKeyUsage = serverAuth
subjectAltName = @alt_names
[alt_names ]
DNS.1 = ta.server.local
DNS.2 = localhost
DNS.3 = tadb
EOF
	)

	openssl req \
	-newkey rsa:2048 \
    -keyout ../key/private.pem \
    -x509 \
    -nodes \
    -new \
    -out ../key/public.crt \
    -subj $(echo -n $cert_subj|tr -d ' ') \
    -reqexts 'ta_cert_extensions' \
    -extensions 'ta_cert_extensions' \
    -config <(cat "$ssl_config" \
            <(printf "$cert_custom")) \
    -sha256 \
    -days 365 2> >(log_stdin)
	log "Finished: Generating key and cert"

}

function base64Encode {
	if uname -s | grep 'Darwin' >/dev/null; then
		# bash commands modified for mac
		base64 -i ../key/private.pem -o ../key/private-base64
		base64 -i ../key/public.crt -o ../key/public-base64
	else
		base64 -w 0 ../key/private.pem >../key/private-base64 2> >(log_error_stdin)
		base64 -w 0 ../key/public.crt >../key/public-base64 2> >(log_error_stdin)
	fi
}

# set base64 encoded values of the key and cert to environment variables
function setKeyAndCertEnvVar() {
	log "Setting key and cert"
	export TA_PRIVATE_KEY=$(cat ../key/private-base64 | xargs)
	export TA_PUBLIC_KEY=$(cat ../key/public-base64 | xargs)
}
