#!/usr/bin/env bash
# Created by Huang, Fuguo (aka ken) on 23.2.2021.

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

function enableTls() {
	if [[ ! -d "../logs" ]]; then
		mkdir ../logs
	fi

	# linked file descriptor #3 with standard out, saved, and replace stdout with file log file
	export TA_LOCAL_TEMP_SECURITY_LOG=enable_security_$(date +"%Y%m%d").log
	exec 3>&1 >>../logs/$TA_LOCAL_TEMP_SECURITY_LOG

	LOG_DATE=$(date +"%H:%M:%S")

	# echo "$LOG_DATE Will enable TLS"
	log "Will enable TLS"
	source ./enableTlsHelper.sh

	if [[ -f "../key/private.pem" && -f "../key/public.crt" ]]; then
		# echo "$LOG_DATE Found private key and public cert. Will use these two files for internal TLS"
		log "Found private key and public cert. Will use these two files for internal TLS"
		# base 64 encode key and cert files
		base64Encode
		setKeyAndCertEnvVar
	elif [[ -n "${TA_PRIVATE_KEY}" && -n "${TA_PUBLIC_KEY}" ]]; then
		# echo "$LOG_DATE Found private key and public cert in environment variables. Will use these two environment variables for internal TLS"
		log "Found private key and public cert in environment variables. Will use these two environment variables for internal TLS"
		export TA_PRIVATE_KEY=$TA_PRIVATE_KEY
		export TA_PUBLIC_KEY=$TA_PUBLIC_KEY
	else
		# echo "$LOG_DATE private key and public cert are not provided. Will generate private key and public cert."
		log "private key and public cert are not provided. Will generate private key and public cert."
		if [[ ! -d "../key" ]]; then
			mkdir ../key
		fi
		# generate key and cert files
		generateKeyAndCert
		# base 64 encode key and cert files
		base64Encode
		setKeyAndCertEnvVar
	fi
	# revert back to stdout, and close file descriptor #3
	exec >&3 3>&-
}

function updateLibertyEnv() {
	if uname -s | grep 'Darwin' >/dev/null; then
		# sed commands modified for mac
		sed -i '' -e 's/<internal-server-port>/'${TA_LOCAL_INTERNAL_SERVER_PORT}'/g' ./.env
	else
		sed -i 's/<internal-server-port>/'${TA_LOCAL_INTERNAL_SERVER_PORT}'/g' ./.env
	fi
}

function updateUiEnv() {
	if uname -s | grep 'Darwin' >/dev/null; then
		# sed commands modified for mac
		sed -i '' -e 's/<external-ui-port>/'${TA_EXTERNAL_UI_PORT}'/g' ./.env
	else
		sed -i 's/<external-ui-port>/'${TA_EXTERNAL_UI_PORT}'/g' ./.env
	fi
}

function updateNeo4JEnv() {
	# true or false
	VALUE=$1
	TEMP_NEO4J_PROTOCOL=$2
	TLS_LEVEL=$3
	if uname -s | grep 'Darwin' >/dev/null; then
		# sed commands modified for mac
		sed -i '' -e 's/<neo4j-ssl-bolt-enable>/'${VALUE}'/g' ./.env
		sed -i '' -e 's/<neo4j-ssl-https-enable>/'${VALUE}'/g' ./.env
		sed -i '' -e 's/<neo4j-connector-https-enable>/'${VALUE}'/g' ./.env
		sed -i '' -e 's/<neo4j-protocol>/'${TEMP_NEO4J_PROTOCOL}'/g' ./.env
    sed -i '' -e 's/<neo4j-connector-botl-tls-level>/'${TLS_LEVEL}'/g' ./.env
	else
		sed -i 's/<neo4j-ssl-bolt-enable>/'${VALUE}'/g' ./.env
		sed -i 's/<neo4j-ssl-https-enable>/'${VALUE}'/g' ./.env
		sed -i 's/<neo4j-connector-https-enable>/'${VALUE}'/g' ./.env
		sed -i 's/<neo4j-protocol>/'${TEMP_NEO4J_PROTOCOL}'/g' ./.env
    sed -i 's/<neo4j-connector-botl-tls-level>/'${TLS_LEVEL}'/g' ./.env
	fi
}

function updateProtocol() {
	PROTOCOL=$1
	if uname -s | grep 'Darwin' >/dev/null; then
		# sed commands modified for mac
		sed -i '' -e 's/<protocol>/'${PROTOCOL}'/g' ./.env
	else
		sed -i 's/<protocol>/'${PROTOCOL}'/g' ./.env
	fi
}
