echo OFF
set /p portnumber=<config.txt

SET "port=%portnumber:~5%"

echo Creating the Volumes
podman volume create tadb
podman volume create tagraph
echo Creating the Pod
podman pod create -n ta_pod -p %port%:3000 -p 2220:9080
echo Installing and Configuring the Application Modernization Accelerator Containers

SET /P VAR_C=<%TMP%\var_c
podman load -i %VAR_C%

ECHO:
podman run  -d --pod ta_pod --name tadb --env-file env_couch.list -v "tadb:/opt/couchdb/data" icr.io/appcafe/transformation-advisor-db:4.5.2 > null
podman run  -d --pod ta_pod --name tagraph --env-file  env_graph.list -v "tagraph:/data" icr.io/appcafe/transformation-advisor-neo4j:4.5.2 > null
podman run -d --pod ta_pod --name taserver  --env-file env_server.list icr.io/appcafe/transformation-advisor-server:4.5.2 > null
podman run -d --pod ta_pod --name taui  --env-file env_ui.list icr.io/appcafe/transformation-advisor-ui:4.5.2 > null

timeout 10 > null
echo:
echo:
echo Application Modernization Accelerator is available at: http://localhost:%port%
echo:
