#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"
source ./imageHelper.sh
###create the podman/docker alias
if [[ $TA_LOCAL_TEMP_PODMAN_INSTALL = true ]]; then
  shopt -s expand_aliases
  source ./.podman_config
fi


### Get the TA Docker Container IDs

function stopLocalPods {


        ui=$(docker ps  | grep transformation-advisor-ui | awk '{print $1}')
        couch=$(docker ps  | grep transformation-advisor-db | awk '{print $1}')
        server=$(docker ps  | grep transformation-advisor-server | awk '{print $1}')
        graph=$(docker ps  | grep transformation-advisor-neo4j | awk '{print $1}')

        #### Stop All TA Docker Containers

        while :; do
                printf "."
                sleep 1
        done &
        trap "kill $!" EXIT 2>/dev/null #Die with parent if we die prematurely
        disown

        for a in $ui; do
                docker kill $a >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for b in $couch; do
                docker kill $b >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for c in $server; do
                docker kill $c >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for d in $graph; do
                docker stop $d >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        podRun=$(which podman 2>&1)
        if [[  "$podRun" ||  $podRun =~ "/usr/bin/podman" ]] && [[  $podRun =~ "/bin/podman" ]] ; then
        pod=$(docker pod ps | grep ta_pod | awk '{print $1}')

                for e in $pod; do
                        docker pod rm -f $e 2>/dev/null
                done
        fi


        echo ""
        kill $! && trap " " EXIT 2>/dev/null

}

function removePods {

        ui=$(get_ui_id -a)
        couch=$(get_db_id -a)
        server=$(get_server_id -a)
        neo4j=$(get_graph_id -a)


        #### remove TA Docker Containers

        while :; do
                printf "."
                sleep 1
        done &
        trap "kill $!" EXIT 2>/dev/null #Die with parent if we die prematurely
        disown

        for a in $ui; do
                log "Removing UI => $a"
                docker rm -f $a >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for b in $couch; do
                log "Removing COUCH => $a"
                docker rm -f $b >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for c in $server; do
                log "Removing ADVISOR => $a"
                docker rm -f $c >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        for d in $neo4j; do
                log "Removing GRAPH => $a"
                docker rm -f $d >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
        done

        # we prioritise to use docker if available
        if [[ $TA_LOCAL_TEMP_DOCKER_INSTALL = true ]]; then
                net=`docker network ls | grep ta_local | awk '{print $1}'`
                if [[ ! -z $net ]] ; then
                        docker network rm $net
                fi
        fi
        # assume either docker or podman is available, otherwise should failed in pre-req checking
        if [[ $TA_LOCAL_TEMP_PODMAN_INSTALL = true ]]; then
                pod=`docker pod list | grep ta_pod | awk '{print $2}'`
                if [[ ! -z $pod ]] ; then
                        docker pod rm $pod
                fi
        fi



        echo ""
        kill $! && trap " " EXIT 2>/dev/null

}

