#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"

#clean up before install

mkdir -p ../logs

while :; do
	printf "."
	sleep 1
done &
trap "kill $!" EXIT 2>/dev/null #Die with parent if we die prematurely
disown
./stopBeforeInstallLocal.sh >../logs/uninstall_$(date +"%Y%m%d_%H%M%S").log
echo ""
kill $! && trap " " EXIT 2>/dev/null
