#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"

source ./.security_config

###create the podman/docker alias
if [[ $TA_LOCAL_TEMP_PODMAN_INSTALL = true ]]; then
  shopt -s expand_aliases
  source ./.podman_config
fi



source ./installHelper.sh
source ./findHost.sh

# clean the env file
./copy_back_files.sh

replaceHost
sleep 1

## start docker compose
startDockerCompose



# set the protocol
PROTOCOL=http
# translate into lower case
TA_AUTH_ENABLE_TLS_lower_case=$(echo "$TA_AUTH_ENABLE_TLS" | tr '[:upper:]' '[:lower:]')

if [[ $TA_AUTH_ENABLE_TLS_lower_case == 'true' ]]; then
	PROTOCOL=https
fi

# this will print dots like ... in a background job
source ./helper.sh
showConfiguringTA

# this will kill the dots generation background job
killBackgroundJob

displayTARunningStatus
