#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"

source ./.security_config
source ./localTempPodman.sh
source ./logging.sh

source ./installHelper.sh
source ./checkPodsRunning.sh
source ./findHost.sh
replaceHost
sleep 1
sleep 1
## start docker compose
startDockerCompose

setProtocol
source ./helper.sh

########### testing for ui, couchDB and liberty containers are running #######
header "Checking Pods are running"
checkUIPodRunning
checkDBPodRunning
checkNeo4jPodRunning
checkAdvisorPodRunning
##############################################################################

displayTARunningStatus
