# Created by Huang, Fuguo (aka ken) on 17.1.2022.

function displayTARunningStatus() {

	source ./.env 2>/dev/null

	uiID=$(docker ps | grep transformation-advisor-ui | awk '{print $1}')
	taVersion=$(docker inspect $uiID | grep version | tail -n 1 | awk -F : '{print $2}' | sed 's/^.//' | tr -d '"')

	status_header
	to_terminal "${PRODUCT_NAME} ${taVersion} is available for use at the following URL> ${TA_PUBLIC_ACCESSIBLE_UI_URL:-'URL not found, please check logs for errors'}"

}

function sourceConfig(){
	# if there is dev file, use it
	if [ -f "${TA_LOCAL_CONFIG_DEV}" ]; then
		log "$TA_LOCAL_CONFIG_DEV is provided. Using dev file."
		source "$TA_LOCAL_CONFIG_DEV"
	else
		source "$TA_LOCAL_CONFIG"
	fi
}