#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

function getProductName {

    product_name="Transformation Advisor"

    dir_name=$(basename "$PWD")
    
    if [[ ${dir_name} == *"transformation-advisor"* ]]; then
        product_name="Transformation Advisor"
        ta_product

    elif [[ ${dir_name} == *"application-modernization-accelerator"* ]]; then
        product_name="Application Modernization Accelerator"
        ama_product
    else
        to_terminal "No product installed "
    fi
    export PRODUCT_NAME=${product_name}

}

function getProductDoc {

    doc_name="Transformation Advisor"

    dir_name=$(basename "$PWD")

    if [[ ${dir_name} == *"transformation-advisor"* ]]; then
       doc_name="https://ibm.biz/ta-product"

    elif [[ ${dir_name} == *"application-modernization-accelerator"* ]]; then
        doc_name="https://ibm.biz/ama-product"

    else
        echo "No product installed "
    fi
    export DOC_NAME=${doc_name}
}

function getProductShort {

    short_name="Transformation Advisor"

    dir_name=$(basename "$PWD")

    if [[ ${dir_name} == *"transformation-advisor"* ]]; then
       short_name="ta"

    elif [[ ${dir_name} == *"application-modernization-accelerator"* ]]; then
        short_name="ama"

    else
        echo "No product installed "
    fi
    export SHORT_NAME=${short_name}
}

