#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

# modified by Huang, Fuguo (aka ken) on 08.03.2021.
# replace the <host> in env file
# source the TA_LOCAL_RUNTIME_HOST_IP=<host/ip> in the environment variables at installation time

function getHostIp() {
	# Local host is used for macos and windows wsl so we only need to set ip for linux
	# macOS ip did not work for migration plan but localhost did, so using localhost for IP on mac
	ta_temp_host=localhost

	if uname -s | grep 'Darwin' >/dev/null; then
		log "On macOS, setting runtime host IP to localhost"
	fi

	if [[ -d  "/mnt/c/" ]]; then
		log "On windows WSl, setting runtime host IP to localhost"
	fi

	if [[ "$(uname -s)" == "Linux" ]]; then
		log "On linux, setting runtime host IP"
  		# Red Hat Linux
		host=$(hostname -f)

		if [ "$host" != "${host/./}" ]; then
			host=$(hostname -f)
		else
			host=$(ip route get 8.8.8.8 | awk -F"src " 'NR==1{split($2,a," ");print a[1]}')
		fi

		ta_temp_host=${host}
    fi

	export TA_LOCAL_RUNTIME_HOST_IP=${ta_temp_host}
}

function replaceHost() {
	getHostIp
	if uname -s | grep 'Darwin' >/dev/null; then
		#	macOS
		sed -i '' -e 's/<host>/'$TA_LOCAL_RUNTIME_HOST_IP'/g' ./.env
		sed -i '' -e 's/<host>/'$TA_LOCAL_RUNTIME_HOST_IP'/g' ./env_ui.list
		sed -i '' -e 's/<host>/'$TA_LOCAL_RUNTIME_HOST_IP'/g' ./env_server.list
	else
		# Red Hat Linux and windows
		sed -i 's/<host>/'${TA_LOCAL_RUNTIME_HOST_IP}'/g' ./.env
		sed -i 's/<host>/'${TA_LOCAL_RUNTIME_HOST_IP}'/g' ./env_ui.list
		sed -i 's/<host>/'${TA_LOCAL_RUNTIME_HOST_IP}'/g' ./env_server.list
	fi
}

function host_matches_env_file(){
	if grep -q "$TA_LOCAL_RUNTIME_HOST_IP" ./.env; then
		log "Host IP already set in .env file - no reconfiguration needed"
		return 0
	else
		header "Host IP mis-match, will start reconfiguration"
		return 1
	fi
}
