#!/bin/bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2025
# --------------------------------------------- 


required_images=("transformation-advisor-server" "transformation-advisor-ui" "transformation-advisor-db" "transformation-advisor-neo4j")


podman_image_trust_is_set() {
    # Check if image trust for 'icr.io' is set
    # This is only run if running as rootless
    # returns 0 if icr.io is found
    # returns 1 if not found
    podman image trust show | grep -q "icr.io"
    return $?
}

podman_set_trust(){
    if ! podman_image_trust_is_set; then
        podman image trust set -t accept icr.io
    fi
}


## docker can be docker or podman - depends on alias
is_cm_running(){
	## Use exit code of cm info so we don't have to rely on string match
	docker info > /dev/null 2>&1;
	exit_code=$?
	if [[  $exit_code -ne 0 ]]; then
		to_terminal "Docker installed but not running. Please start docker and re-run the script."
		exit
	fi
}

ensure_required_images_exist() {
	local images=("$@")
	local total=${#images[@]}
	local count=0

	for image in "${images[@]}"; do
		if docker images --format '{{.Repository}}' | grep -qE "${image}"; then
			((count++))
		fi
	done

	if [[ $count -eq $total ]]; then
		echo "all-present"
	elif [[ $count -gt 0 ]]; then
		echo "some-present"
	else
		echo "none-present"
	fi
}

image_status=$(ensure_required_images_exist "${required_images[@]}")