#!/usr/bin/env bash

#---------------------------------------------
#Licensed Materials - Property of IBM
#(C) Copyright IBM Corporation 2021
#---------------------------------------------
#run scripts at relative path
REGISTRY=""
uiID=""
tag=""
imageName=""
PULL_OUTPUT_FILE="$(mktemp)"


update_image_details() {
  TA_LOCAL_CONFIG=./.configuration
  TA_LOCAL_CONFIG_DEV=./.configuration.dev

  if [ -f "$TA_LOCAL_CONFIG_DEV" ]; then
    log "Running in DEV Environment"
    REGISTRY="cp.stg.icr.io/cp"
  else
    REGISTRY="icr.io/appcafe"
  fi

  uiID=`docker images | grep $REGISTRY/transformation-advisor-ui | awk '{print $3}'`
  tag=`docker images | grep $REGISTRY/transformation-advisor-ui | awk '{print $2}'`
  imageName=`docker images | grep $REGISTRY/transformation-advisor-ui | awk '{print $1}'`
}

scriptdir="$(dirname "$0")"
cd "$scriptdir"

source ./localTempPodman.sh
source ./logging.sh
source ./spinner.sh

update_image_details

if [[ -z "$imageName" ]]; then
  log "${PRODUCT_NAME} is not installed."
  exit 1
fi

##tag the image to be latest
docker tag $imageName:$tag $imageName:latest

checkForLatestUiImage(){
  if [ -f "$TA_LOCAL_CONFIG_DEV" ]; then
    log "$TA_LOCAL_CONFIG_DEV is provided. Logging into staging so we can use the dev file."
    ./.login.dev.sh $TA_LOCAL_TEMP_PODMAN_INSTALL 
  fi
  docker pull $REGISTRY/transformation-advisor-ui:latest | tee "$PULL_OUTPUT_FILE"
  
}

run_with_spinner checkForLatestUiImage "Checking if newer version of ${PRODUCT_NAME} is available" "Checking Latest" "CHECKED"

PULL_OUTPUT=$(cat "$PULL_OUTPUT_FILE")

if [[ "$PULL_OUTPUT" == *"Image is up to date"* || "$PULL_OUTPUT" == *"$uiID"* ]]; then
  status_header
  to_terminal "${PRODUCT_NAME} is up to date."
  docker rmi -f $imageName:latest | log_stdin
else
  status_header
  to_terminal "A newer version of ${PRODUCT_NAME} is available. Please select option 2 or 3 to uninstall. "
  to_terminal "Then download the latest ${PRODUCT_NAME} LOCAL zip ${DOC_NAME} and install it."
  docker rmi -f $imageName:latest | log_stdin
fi

rm -f "$PULL_OUTPUT_FILE"