echo off

set /p portnumber=<config.txt

SET "port=%portnumber:~5%"

echo Stopping Application Modernization Accelerator
podman stop tadb
podman stop tagraph
podman stop taserver
podman stop taui

echo Removing Application Modernization Accelerator containers
podman rm -f tadb tagraph taserver taui

echo Remove Application Modernization Accelerator pod

podman pod rm -f ta_pod

echo Creating the Pod
podman pod create -n ta_pod -p %port%:3000 -p 2220:9080

podman run  -d --pod ta_pod --name tadb --env-file env_couch.list -v "tadb:/opt/couchdb/data" icr.io/appcafe/transformation-advisor-db:4.5.1 > null
podman run  -d --pod ta_pod --name tagraph --env-file  env_graph.list -v "tagraph:/data" icr.io/appcafe/transformation-advisor-neo4j:4.5.1 > null
podman run -d --pod ta_pod --name taserver  --env-file env_server.list icr.io/appcafe/transformation-advisor-server:4.5.1 > null
podman run -d --pod ta_pod --name taui  --env-file env_ui.list icr.io/appcafe/transformation-advisor-ui:4.5.1 > null

echo Starting Application Modernization Accelerator
for /L %%A in (1,1,20) do (<nul set /p "=."& >nul timeout 3)
echo:
echo:

echo Application Modernization Accelerator is available at: http://localhost:%port%
echo:
