#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"

source ./.security_config
source ./localTempPodman.sh
source ./logging.sh

source ./installHelper.sh
source ./checkPodsRunning.sh
source ./imageHelper.sh

source ./installHelper.sh
source ./findHost.sh
replaceHost

sleep 1

ui=$(get_ui_id -a)
couch=$(get_db_id -a)
server=$(get_server_id -a)
neo4j=$(get_graph_id -a)

if [[ ! -z $ui && ! -z $couch && ! -z $server && ! -z $neo4j ]]; then
  startLocal
else
  startDockerCompose
fi

setProtocol
source ./helper.sh

########### testing for ui, couchDB and liberty containers are running #######
header "Checking Pods are running"
checkUIPodRunning
checkDBPodRunning
checkNeo4jPodRunning
checkAdvisorPodRunning
##############################################################################

displayTARunningStatus
