#!/bin/bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2025
# ---------------------------------------------

# source configure before installing
TA_LOCAL_CONFIG=./.configuration
TA_LOCAL_CONFIG_DEV=./.configuration.dev

# if there is dev file, use it
if [ -f "$TA_LOCAL_CONFIG_DEV" ]; then
  source "$TA_LOCAL_CONFIG_DEV"
else
  source "$TA_LOCAL_CONFIG"
fi

tadbResourcesOptions=(
--memory="${TA_LOCAL_CONFIG_COUCH_MEMORY}" 
--cpus="${TA_LOCAL_CONFIG_COUCH_CPU}"
)

tagraphResourcesOptions=(
--memory="${TA_LOCAL_CONFIG_NEO4J_MEMORY}" 
--cpus="${TA_LOCAL_CONFIG_NEO4J_CPU}"
)

taserverResourcesOptions=(
--memory="${TA_LOCAL_CONFIG_SERVER_MEMORY}" 
--cpus="${TA_LOCAL_CONFIG_SERVER_CPU}"
)

tauiResourcesOptions=(
--memory="${TA_LOCAL_CONFIG_UI_MEMORY}" 
--cpus="${TA_LOCAL_CONFIG_UI_CPU}"
)