# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021-2023
# ---------------------------------------------

source ./scripts/input_validation.sh

function  acceptLicense {
   header "License Agreements"
   prompt_and_read "
      \t1) I have read and agreed to the license agreements(see LICENSE file)\n
      \t2) Don't accept the license agreements\n" CHOICE
   basic_input_validation "$CHOICE" 1 2

   case $CHOICE in
      1) addSoftwareTag
         ./scripts/launch.sh $1;;

      2) rm -rf ./.license_accepted
      exit ;;
   esac
   exit

}

function licenseType {
   header "Select from the menu which license you are installing this product under"
   prompt_and_read "
      \t1) IBM Application Modernization Accelerator 4.5.0 (Evaluation) - L-YWRJ-XY4MQV\n
      \tq) Quit\n " CHOICE
   basic_input_validation "$CHOICE" 1 1

   if [ "$CHOICE" == "1" ];then
      touch ./.license_accepted
      echo "IBM Application Modernization Accelerator 4.5.0(Evaluation) - L-YWRJ-XY4MQV" > ./.license_accepted
   fi

}

function addSoftwareTag {

   mkdir -p ./swidtag
   rm -f ./swidtag/*
   cp ./resources/ama/swtag/* ./swidtag
   
}
