#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"


###create the podman/docker alias
if [[ $TA_LOCAL_TEMP_PODMAN_INSTALL = true ]]; then
  shopt -s expand_aliases
  source ./.podman_config
fi

### Get the TA Docker Container IDs

ui=$(get_ui_id)
couch=$(get_db_id)
server=$(get_server_id)
neo4j=$(get_graph_id)

#### Rename Docker Name ########

docker rename $server taserver
docker rename $couch tadb
docker rename $ui taui
docker rename $neo4j tagraph
