# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2023
# ---------------------------------------------




###create the podman/docker alias
###source ./createPodmanAlias.sh
###createPodmanAlias
source ./logging.sh
source ./imageHelper.sh

###create the podman/docker alias
if [[ $TA_LOCAL_TEMP_PODMAN_INSTALL = true ]]; then
  shopt -s expand_aliases
  source ./.podman_config
fi

###get the container ID's
ui=$(get_ui_id)
couch=$(get_db_id)
server=$(get_server_id)
neo4j=$(get_graph_id)


mkdir -p ../${SHORT_NAME}LocalInfo

date=`date +"%Y%m%d_%H%M%S"`

get_container_env_vars() {
  local container_id="$1"
  local env_pattern="$2"
  # Fetch and filter environment variables
  local env_vars
  if ! env_vars=$(podman inspect "$container_id" --format '{{range .Config.Env}}{{.}} {{end}}' 2>/dev/null); then
      terminal_warn "Error: Failed to inspect container '$container_id'. Is it running?"
      return 1
  fi
  # Define sensitive patterns as a regex string (OR-separated)
  local sensitive_patterns='PRIVATE_KEY|PUBLIC_KEY|PASS|API_KEY'

  echo "$env_vars" | \
  awk '{
    # Remove all double quotes from the current line
    gsub(/"/, "")
    # Loop through each field (NF = number of fields, separated by whitespace)
    for(i=1; i<=NF; i++) {
      # Check if the field contains an equals sign (=), which indicates its a key=value pair
      # This avoids processing malformed or empty fields
      # Print the cleaned key=value pair (quotes already removed)
      if ($i ~ /=/)  print $i
    }
  }' | \
  grep -v -E "PRIVATE_KEY|PUBLIC_KEY|PASS|API_KEY" | \
  grep -F "$env_pattern" >> "${local_info}"

} 

#######get the docker / podman version
local_info="../$1"
message_log="../$2"
echo "" >> "${local_info}"
log "Get the docker / podman version"
echo "Get the docker / podman version" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
docker version >> "${local_info}"
log "done"

####get images
echo "" >> "${local_info}"
log "Get images"
echo "Get images" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
docker images >> "${local_info}"
log "done"

####get running containers 
echo "" >> "${local_info}"
echo "Get the running containers" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the containers"
docker ps -a >> "${local_info}"
log "done"


####get the server env variable
echo "" >> "${local_info}"
echo "Get the server env variable" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the server env variable"
# docker exec -ti $server env | grep TA  >> "${local_info}"
get_container_env_vars $server "TA"
log "done"
 
####get the  ui env variable
echo "" >> "${local_info}"
echo "Get the ui env variable" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the ui env variable"
# docker exec -ti $ui env | grep TA  >> "${local_info}"
get_container_env_vars $ui "TA"
log "done"

####get the couchDB env variable
echo "" >> "${local_info}"
echo "Get the couchDB env variable" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the couchDB env variable"
# docker exec -ti $couch env | grep COUCH  >> "${local_info}"
get_container_env_vars $couch "COUCH"
log "done"


####get the neo4j env variable
echo "" >> "${local_info}"
echo "Get the neo4j env variable" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the neo4j env variable"
# docker exec -ti $neo4j env | grep NEO  >> "${local_info}"
get_container_env_vars $neo4j "NEO"
log "done"

####get the server log
echo "" >> "${local_info}"
echo "Get the server log" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the server log"

docker cp $server:/logs/messages.log ${message_log}
log "done"

if [[ -e "/etc/redhat-release" ]]; then
  ####get the linux version 
  echo "" >> "${local_info}"
  echo "Get the linux version" >> "${local_info}"
  echo "--------------------------" >> "${local_info}"
  log "Get the the linux version"

  cat /etc/redhat-release  >> "${local_info}"
  log "done"
fi

####get the number of CPU 
echo "" >> "${local_info}"
echo "Get the number of CPUs" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the number of CPUs"

if uname -s | grep 'Darwin'; then
  ysctl hw.ncpu | awk '{print $2}' >> "${local_info}"
else
 cat /proc/cpuinfo | grep proc | wc -l  >> "${local_info}"
fi

log "done"

####get the memory 
echo "" >> "${local_info}"
echo "Get the memory info" >> "${local_info}"
echo "--------------------------" >> "${local_info}"
log "Get the memory info"

if uname -s | grep 'Darwin'; then
  echo MemTotal: `sysctl hw.memsize | awk '{print $2}'` >> "${local_info}"
else
  grep MemTotal /proc/meminfo  >> "${local_info}"
fi
log "done"


if uname -a | grep "Ubuntu"; then
        ####get the ubuntu version
        echo "" >> "${local_info}"
        echo "Get the Ubuntu version" >> "${local_info}"
        echo "--------------------------" >> "${local_info}"
        log "Get the Ubuntu version"

        lsb_release -a  >> "${local_info}"
        log "done"
fi

ta_read_value_from_env_var=`grep TA_READ_VALUE_FROM_ENV_VAR .env | cut -d'=' -f 2- | awk '!/^[[:space:]]*$/'`
if [[ -z "${ta_read_value_from_env_var}" || "${ta_read_value_from_env_var}" == false ]] && [[ "${TA_LOCAL_TEMP_PODMAN_INSTALL}" == true ]]; then
    echo "" >> "${local_info}"
    echo "Get Podman secrets" >> "${local_info}"
    echo "--------------------------" >> "${local_info}"
    log "Get Podman secrets"

    podman secret ls  >> "${local_info}"
    log "done"
fi

