#!/usr/bin/env bash

# ---------------------------------------------
# Licensed Materials - Property of IBM
# (C) Copyright IBM Corporation 2021
# ---------------------------------------------

#run scripts at relative path
scriptdir="$(dirname "$0")"
cd "$scriptdir"
trap 'exit 130' INT TERM

### you can also set TA_LOCAL_TEMP_PODMAN_INSTALL to true manually, to run this file with podman.
source ./localTempPodman.sh
source ./secretHelper.sh

source ./imageHelper.sh
#############################

stopTA

#### Remove TA Containers ###################

removeContainers

#### Remove TA Images #####################

ui_image=$(docker images | grep transformation-advisor-ui | awk '{print $3}')
couch_image=$(docker images | grep transformation-advisor-db | awk '{print $3}')
server_image=$(docker images | grep transformation-advisor-server | awk '{print $3}')
neo4j_image=$(docker images | grep transformation-advisor-neo4j | awk '{print $3}')

# to keep docker images, comment out the following codes
log "Start removing images"

for i in $ui_image; do
  log "Removing UI image"
	docker rmi -f $i
done

for j in $couch_image; do
  log "Removing DB image"
	docker rmi -f $j
done

for k in $server_image; do
	log "Removing SERVER image"
  docker rmi -f $k
done

for l in $neo4j_image; do
	log "Removing NEO4J image"
  docker rmi -f $l
done

sleep 5

#######remove the network



# we prioritise to use docker if available
if [[ ${TA_LOCAL_TEMP_DOCKER_INSTALL} = true ]]; then
	net=`docker network ls | grep ta_local | awk '{print $1}'`
  if [[ ! -z $net ]] ; then
   docker network rm $net
  fi
fi
# assume either docker or podman is available, otherwise should failed in pre-req checking
if [[ ${TA_LOCAL_TEMP_PODMAN_INSTALL} = true ]]; then
	pod=`docker pod list | grep ta_pod | awk '{print $2}'`
  if [[ ! -z $pod ]] ; then
   docker pod rm $pod
  fi
fi


### Find the hostname and edit the environment files #######
############################################################

source ./findHost.sh
replaceHost

## Clear podman secrets - these will be generated during install 
## could be pre-exisitng from previous install if not uninstalled correctly
removeAllTaSecrets

## Remove config file hash file - used for reconfiguration check
rm -rf ./.configuration_file_hash

sleep 5
